/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.util;

import freemarker.ext.util.IdentityHashMap;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;

public class ModelCache {
    private boolean useCache = false;
    private Map modelCache = null;
    private ReferenceQueue refQueue = null;
    private final ObjectWrapper wrapper;

    public ModelCache(ObjectWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public synchronized void setUseCache(boolean useCache) {
        this.useCache = useCache;
        if (useCache) {
            this.modelCache = new IdentityHashMap();
            this.refQueue = new ReferenceQueue();
        } else {
            this.modelCache = null;
            this.refQueue = null;
        }
    }

    public TemplateModel getInstance(Object object, ModelFactory factory) {
        if (this.useCache) {
            TemplateModel model = this.lookup(object);
            if (model == null) {
                model = factory.create(object, this.wrapper);
                this.register(model, object);
            }
            return model;
        }
        return factory.create(object, this.wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.modelCache != null) {
            Map map = this.modelCache;
            synchronized (map) {
                this.modelCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TemplateModel lookup(Object object) {
        ModelReference ref = null;
        Map map = this.modelCache;
        synchronized (map) {
            ref = (ModelReference)this.modelCache.get(object);
        }
        if (ref != null) {
            return ref.getModel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void register(TemplateModel model, Object object) {
        Map map = this.modelCache;
        synchronized (map) {
            ModelReference queuedRef;
            while ((queuedRef = (ModelReference)this.refQueue.poll()) != null) {
                this.modelCache.remove(queuedRef.object);
            }
            this.modelCache.put(object, new ModelReference(model, object, this.refQueue));
        }
    }

    private static final class ModelReference
    extends SoftReference {
        Object object;

        ModelReference(TemplateModel ref, Object object, ReferenceQueue refQueue) {
            super(ref);
            this.object = object;
        }

        TemplateModel getModel() {
            return (TemplateModel)this.get();
        }
    }
}

