/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.wizards.CompositeComponentVisualPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CompositeComponentWizardPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private CompositeComponentVisualPanel component;
    private String text;
    private TemplateWizard wizard;
    Project project;
    SourceGroup[] folders;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String RESOURCES_FOLDER = "resources";
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+\\|{};:'\",<>/?]");
    private static final Pattern INVALID_FOLDERNAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+|{};:'\",<>?]");
    private static final String FROM_EDITOR_PROP = "fromEditor";

    public CompositeComponentWizardPanel(TemplateWizard templateWizard, SourceGroup[] sourceGroupArray, String string) {
        this.wizard = templateWizard;
        this.text = string;
        this.folders = sourceGroupArray;
        this.project = Templates.getProject((WizardDescriptor)templateWizard);
    }

    public Component getComponent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this._getComponent();
        }
        final AtomicReference atomicReference = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    atomicReference.set(CompositeComponentWizardPanel.this._getComponent());
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        return (Component)atomicReference.get();
    }

    public Component _getComponent() {
        if (this.component == null) {
            this.component = new CompositeComponentVisualPanel(this.project, this.folders, this.text);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        Map map;
        String string;
        String string2;
        String string3 = null;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (!(Utilities.isJavaEE6((TemplateWizard)this.wizard) || JSFUtils.isJavaEE5(this.wizard) && JSFUtils.isJSF20(webModule))) {
            string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Not_JSF20");
        }
        if (this.component == null || this.component.getTargetName() == null || this.component.getTargetGroup() == null) {
            return false;
        }
        if (this.component.getTargetFolder() == null || !this.component.getTargetFolder().startsWith(RESOURCES_FOLDER)) {
            string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_No_resources_folder");
        } else if (this.component.getTargetFolder().equals(RESOURCES_FOLDER) || this.component.getTargetFolder().equals(RESOURCES_FOLDER + File.separatorChar)) {
            string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_No_component_folder");
        }
        String string4 = this.component.getTargetName();
        if ("".equals(string4) || INVALID_FILENAME_CHARACTERS.matcher(string4).find()) {
            string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Wrong_Filename");
        }
        if (INVALID_FOLDERNAME_CHARACTERS.matcher(string2 = this.component.getTargetFolder()).find()) {
            string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"ERR_Wrong_Foldername");
        }
        if (webModule != null && webModule.getDocumentBase() != null) {
            string = Templates.getTemplate((WizardDescriptor)this.wizard).getExt();
            string = string.length() == 0 ? "" : "." + string;
            map = webModule.getDocumentBase().getFileObject(string2 + "/" + string4 + string);
            if (map != null) {
                string3 = string4 + string + " already exist";
            }
        }
        if (Boolean.TRUE.equals((Boolean)this.wizard.getProperty("incorrectActionContext"))) {
            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"MSG_Invalid_Selection"));
            return true;
        }
        if (Boolean.TRUE.equals((Boolean)this.wizard.getProperty(FROM_EDITOR_PROP))) {
            string = this.component.getPrefix();
            if (string.length() == 0) {
                string3 = NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"MSG_Library_Prefix_Empty");
            } else {
                map = (Map)this.wizard.getProperty("declaredPrefixes");
                String string5 = this.component.getCompositeComponentURI();
                if (map != null && !string.equals(map.get(string5)) && map.values().contains(string)) {
                    this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"MSG_Already_Used_Prefix", (Object)this.component.getPrefix()));
                    return true;
                }
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string3);
        return string3 == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void readSettings(Object object) {
        if (object instanceof TemplateWizard) {
            Object object2;
            this.wizard = (TemplateWizard)object;
            this.project = Templates.getProject((WizardDescriptor)this.wizard);
            if (this.component == null) {
                this.getComponent();
            }
            if (this.component != null) {
                object2 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
                if (object2 == null) {
                    object2 = this.project.getProjectDirectory();
                }
                String string = Templates.getTargetName((WizardDescriptor)this.wizard);
                boolean bl = Boolean.TRUE.equals((Boolean)this.wizard.getProperty(FROM_EDITOR_PROP));
                this.component.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), (FileObject)object2, string, bl);
            }
            if ((object2 = this.component.getClientProperty("NewFileWizard_Title")) != null) {
                this.wizard.putProperty("NewFileWizard_Title", object2);
            }
        }
    }

    public void storeSettings(Object object) {
        if (object instanceof TemplateWizard) {
            TemplateWizard templateWizard = (TemplateWizard)object;
            if (WizardDescriptor.PREVIOUS_OPTION.equals(templateWizard.getValue())) {
                return;
            }
            if (!templateWizard.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
                FileObject fileObject = Templates.getTemplate((WizardDescriptor)templateWizard);
                String string = this.component.getTargetName();
                if (string.indexOf(47) > 0) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                Templates.setTargetFolder((WizardDescriptor)templateWizard, (FileObject)this.getTargetFolderFromGUI());
                Templates.setTargetName((WizardDescriptor)templateWizard, (String)string);
            }
            templateWizard.putProperty("NewFileWizard_Title", null);
            templateWizard.putProperty("selectedPrefix", (Object)this.component.getPrefix());
        }
    }

    private FileObject getTargetFolderFromGUI() {
        Object object;
        FileObject fileObject = this.component.getTargetGroup().getRootFolder();
        String string = this.component.getTargetFolder();
        String string2 = this.component.getTargetName();
        if (string2.indexOf(47) > 0) {
            object = string2.substring(0, string2.lastIndexOf(47));
            string = string == null || "".equals(string) ? object : string + '/' + (String)object;
        }
        if ((object = string == null ? fileObject : fileObject.getFileObject(string)) == null) {
            try {
                object = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
        return object;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }
}

