/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.spi.impl.CopyAction;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ActionsImplementationFactory {
    private static final Logger LOG = Logger.getLogger(ActionsImplementationFactory.class.getName());
    private static final Lookup.Result<ActionsImplementationProvider> implementations = Lookup.getDefault().lookupResult(ActionsImplementationProvider.class);

    private ActionsImplementationFactory() {
    }

    public static boolean canRename(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            if (!rafi.canRename(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doRename(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            boolean canRename = rafi.canRename(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canRename: %s, %s", rafi, canRename));
            }
            if (!canRename) continue;
            rafi.doRename(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_RenameRefactoring");
    }

    public static boolean canFindUsages(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            if (!rafi.canFindUsages(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doFindUsages(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            boolean canFindUsages = rafi.canFindUsages(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canFindUsages: %s, %s", rafi, canFindUsages));
            }
            if (!canFindUsages) continue;
            rafi.doFindUsages(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_FindUsagesRefactoring");
    }

    public static boolean canDelete(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            if (!rafi.canDelete(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doDelete(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            boolean canDelete = rafi.canDelete(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canDelete: %s, %s", rafi, canDelete));
            }
            if (!canDelete) continue;
            rafi.doDelete(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_SafeDeleteRefactoring");
    }

    public static void doMove(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            boolean canMove = rafi.canMove(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canMove: %s, %s", rafi, canMove));
            }
            if (!canMove) continue;
            rafi.doMove(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_MoveRefactoring");
    }

    public static boolean canMove(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            if (!rafi.canMove(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doCopy(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            boolean canCopy = rafi.canCopy(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canCopy: %s, %s", rafi, canCopy));
            }
            if (!canCopy) continue;
            rafi.doCopy(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_CopyRefactoring");
    }

    public static boolean canCopy(Lookup lookup) {
        for (ActionsImplementationProvider rafi : implementations.allInstances()) {
            if (!rafi.canCopy(lookup)) continue;
            return true;
        }
        return false;
    }

    private static void notifyOutOfContext(String refactoringNameKey) {
        String refactoringName = NbBundle.getMessage(CopyAction.class, (String)refactoringNameKey);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CopyAction.class, (String)"MSG_CantApplyRefactoring", (Object)refactoringName)));
    }
}

