/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.Gems;
import org.openide.util.Parameters;

public final class GemFilesParser {
    private static final String DOT_GEM_SPEC = ".gemspec";
    public static final String VERSION_REGEX = "(\\d+(?:\\.\\d+)*(\\.beta)?)";
    private static final Pattern VERSION_AND_NAME_PATTERN = Pattern.compile("([\\w-]+)\\-(\\d+(?:\\.\\d+)*(\\.beta)?)");
    private static final Logger LOGGER = Logger.getLogger(GemFilesParser.class.getName());
    private final Collection<File> specFiles;
    private Map<String, List<GemInfo>> resultMap;

    private GemFilesParser(Collection<File> specFiles) {
        Parameters.notNull((CharSequence)"files", specFiles);
        this.specFiles = specFiles;
    }

    public void parseGems() {
        this.resultMap = new HashMap<String, List<GemInfo>>();
        for (File spec : this.specFiles) {
            String fileName = spec.getName();
            if (!fileName.endsWith(DOT_GEM_SPEC)) continue;
            String[] nameAndVersion = GemFilesParser.parseNameAndVersion(fileName = fileName.substring(0, fileName.length() - DOT_GEM_SPEC.length()));
            if (nameAndVersion == null) {
                LOGGER.fine("Could not resolve the name and version for " + fileName);
                continue;
            }
            String name = nameAndVersion[0];
            String version = nameAndVersion[1];
            List<GemInfo> versions = this.resultMap.get(name);
            if (versions == null) {
                versions = new ArrayList<GemInfo>();
                this.resultMap.put(name, versions);
            }
            versions.add(new GemInfo(name, version, spec));
        }
        this.sortVersions();
    }

    private void sortVersions() {
        for (String key : this.resultMap.keySet()) {
            List<GemInfo> versions = this.resultMap.get(key);
            Collections.sort(versions);
        }
    }

    private void checkInitialiazed() {
        if (this.resultMap == null) {
            throw new IllegalStateException("Not initialized, you must run the chooseGems method first");
        }
    }

    public static Map<String, List<GemInfo>> getGemInfos(Collection<File> specFiles) {
        GemFilesParser gemFilesParser = new GemFilesParser(specFiles);
        gemFilesParser.parseGems();
        return gemFilesParser.getGemInfos();
    }

    Map<String, List<GemInfo>> getGemInfos() {
        this.checkInitialiazed();
        return this.resultMap;
    }

    public File[] getFiles(boolean onlyLatestVersions) {
        this.checkInitialiazed();
        ArrayList<File> resultList = new ArrayList<File>();
        for (String key : this.resultMap.keySet()) {
            List<GemInfo> versions = this.resultMap.get(key);
            if (onlyLatestVersions) {
                resultList.add(versions.get(0).getSpecFile());
                continue;
            }
            for (GemInfo each : versions) {
                resultList.add(each.getSpecFile());
            }
        }
        return resultList.toArray(new File[resultList.size()]);
    }

    public static String[] parseNameAndVersion(String fileName) {
        Matcher m = VERSION_AND_NAME_PATTERN.matcher(fileName);
        if (!m.find() || m.groupCount() < 2) {
            LOGGER.fine("Couldn't parse name and version for " + fileName);
            return null;
        }
        String name = m.group(1);
        String version = m.group(2);
        return new String[]{name, version};
    }

    public static String[] parseNameAndVersion(URL gemUrl) {
        return GemFilesParser.parseNameAndVersion(Gems.getGemName(gemUrl));
    }
}

