/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomizerNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.openide.util.Lookup;

public final class CustomizerRootNodeProvider {
    private static CustomizerRootNodeProvider instance = null;

    public static CustomizerRootNodeProvider getInstance() {
        if (instance == null) {
            instance = new CustomizerRootNodeProvider();
        }
        return instance;
    }

    public List<CustomizerNode> getCustomizerNodes(Lookup lookup) {
        ArrayList<CustomizerNode> list = new ArrayList<CustomizerNode>();
        for (CustomizerNodeProvider provider : CustomizerRootNodeProvider.getCustomizerNodeProviders()) {
            CustomizerNode node = provider.factoryCreate(lookup);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public List<CustomizerNode> getCustomizerNodes(String id, Lookup lookup) {
        ArrayList<CustomizerNode> list = new ArrayList<CustomizerNode>();
        List<CustomizerNode> nodes = this.getCustomizerNodes(lookup);
        for (CustomizerNode n : nodes) {
            if (n == null || !n.getName().equals(id)) continue;
            list.add(n);
        }
        return list;
    }

    private static Set<CustomizerNodeProvider> getCustomizerNodeProviders() {
        HashSet<CustomizerNodeProvider> providers = new HashSet<CustomizerNodeProvider>();
        Lookup.Template template = new Lookup.Template(CustomizerNodeProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        for (CustomizerNodeProvider caop : result.allInstances()) {
            providers.add(caop);
        }
        return providers;
    }
}

