/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public final class ExecUtil {
    private static final Logger log = DLightLogger.getLogger(ExecUtil.class);

    public static void setExecutionPermissions(List<String> files) {
        if (files.isEmpty()) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String f : files) {
            String fullPath = ExecUtil.getFullPath(f);
            if (!new File(fullPath).exists()) continue;
            paths.add(fullPath);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add("755");
        commands.addAll(paths);
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            pb.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getFullPath(String relpath) {
        File file = InstalledFileLocator.getDefault().locate(relpath, null, false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return relpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> runScript(String script, String params) {
        log.finest("Run script " + script + " " + params);
        ArrayList<Integer> res = new ArrayList<Integer>();
        File scriptFile = InstalledFileLocator.getDefault().locate("bin/" + script, null, false);
        if (scriptFile == null) {
            log.severe("Script " + script + " not found!");
            return Collections.emptyList();
        }
        InputStreamReader reader = null;
        try {
            int c;
            Process process = Runtime.getRuntime().exec("/bin/sh " + scriptFile.getAbsolutePath() + " " + params);
            InputStream is = process.getInputStream();
            reader = new InputStreamReader(Channels.newInputStream(Channels.newChannel(is)));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                if (c == 10) {
                    res.add(Integer.parseInt(sb.toString().trim()));
                    sb = new StringBuilder();
                    continue;
                }
                sb.append((char)c);
            }
            process.destroy();
        }
        catch (ClosedByInterruptException ex) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return res;
    }
}

