/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WatchesColumnModels {
    public static ColumnModel createDefaultLocalsColumn() {
        return new AbstractColumn("DefaultLocalsColumn", "CTL_LocalsView_Column_Name_Name", "CTL_LocalsView_Column_Name_Desc", null);
    }

    public static ColumnModel createDefaultWatchesColumn() {
        return new AbstractColumn("DefaultWatchesColumn", "CTL_WatchesView_Column_Name_Name", "CTL_WatchesView_Column_Name_Desc", null);
    }

    static class WatchesTableCellEditor
    implements TableCellEditor,
    FocusListener {
        private JEditorPane editorPane;
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private Object value;
        private Node node;

        WatchesTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2;
            this.value = object;
            this.editorPane = new WatchesEditorPane("text/x-java", "");
            this.editorPane.addFocusListener(this);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this.editorPane.getInputMap();
            inputMap.put(keyStroke, "none");
            inputMap.put(keyStroke2, "none");
            WatchPanel.setupContext(this.editorPane, null);
            try {
                object2 = object.getClass().getDeclaredField("node");
                ((Field)object2).setAccessible(true);
                this.node = (Node)((Field)object2).get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.node != null) {
                this.editorPane.setText(this.node.getDisplayName());
            }
            object2 = new JScrollPane();
            ((JScrollPane)object2).setHorizontalScrollBarPolicy(31);
            ((JScrollPane)object2).setVerticalScrollBarPolicy(21);
            ((JComponent)object2).setBackground(jTable.getBackground());
            ((JScrollPane)object2).setViewportView(this.editorPane);
            return object2;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.node != null) {
                this.node.setDisplayName(this.editorPane.getText());
            }
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(cellEditorListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(cellEditorListener);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent focusEvent) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>(this.listeners);
                for (CellEditorListener cellEditorListener : arrayList) {
                    cellEditorListener.editingCanceled(new ChangeEvent(this));
                }
            }
        }

        class WatchesEditorPane
        extends JEditorPane {
            KeyStroke enter;

            WatchesEditorPane(String string, String string2) {
                super(string, string2);
                this.enter = KeyStroke.getKeyStroke(10, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                if (this.enter.equals(keyStroke)) {
                    int n = keyEvent.getID();
                    block8: for (KeyListener keyListener : this.getKeyListeners()) {
                        switch (n) {
                            case 400: {
                                keyListener.keyTyped(keyEvent);
                                continue block8;
                            }
                            case 401: {
                                keyListener.keyPressed(keyEvent);
                                continue block8;
                            }
                            case 402: {
                                keyListener.keyReleased(keyEvent);
                            }
                        }
                    }
                    if (!keyEvent.isConsumed() && n == 401) {
                        List list = WatchesTableCellEditor.this.listeners;
                        synchronized (list) {
                            ArrayList arrayList = new ArrayList(WatchesTableCellEditor.this.listeners);
                            for (CellEditorListener cellEditorListener : arrayList) {
                                cellEditorListener.editingStopped(new ChangeEvent(this));
                            }
                        }
                    }
                    keyEvent.consume();
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        }
    }

    public static class AbstractColumn
    extends ColumnModel {
        private String id;
        private String displayName;
        private String shortDescription;
        private Class type;
        private boolean defaultVisible;
        private PropertyEditor propertyEditor;
        private boolean sortable;
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public AbstractColumn(String string, String string2, String string3, Class clazz) {
            this(string, string2, string3, clazz, true);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl) {
            this(string, string2, string3, clazz, bl, null);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl, PropertyEditor propertyEditor) {
            this(string, string2, string3, clazz, bl, propertyEditor, true);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl, PropertyEditor propertyEditor, boolean bl2) {
            this.id = string;
            this.displayName = string2;
            this.shortDescription = string3;
            this.type = clazz;
            this.defaultVisible = bl;
            this.propertyEditor = propertyEditor;
            this.sortable = bl2;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return NbBundle.getBundle(WatchesColumnModels.class).getString(this.displayName);
        }

        public String getShortDescription() {
            return NbBundle.getBundle(WatchesColumnModels.class).getString(this.shortDescription);
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sorted", bl);
            }
        }

        public void setSortedDescending(boolean bl) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
            }
        }

        public int getCurrentOrderNumber() {
            int n = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (n >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++n;
            }
            return n;
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean isSorted() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sorted", false);
            }
            return false;
        }

        public boolean isSortedDescending() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
            }
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        public TableCellEditor getTableCellEditor() {
            return new WatchesTableCellEditor();
        }
    }
}

