/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.api.visual.vmd.VMDMinimizeAbility;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.flow.FlowAccessController;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class FlowViewController
implements DesignDocumentAwareness {
    public static final String FLOW_ID = "flow";
    private JComponent loadingPanel = IOUtils.createLoadingPanel();
    private JPanel visual = new JPanel(new BorderLayout()){

        @Override
        public void requestFocus() {
            super.requestFocus();
            if (FlowViewController.this.view != null) {
                FlowViewController.this.view.requestFocus();
            }
        }

        @Override
        public boolean requestFocusInWindow() {
            if (FlowViewController.this.view != null) {
                super.requestFocusInWindow();
                return FlowViewController.this.view.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }
    };
    private JToolBar toolbar = new JToolBar();
    private JButton overviewButton;
    private DesignDocument designDocument;
    private JComponent view;

    public FlowViewController(DataObjectContext context) {
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setPreferredSize(new Dimension(14, 14));
        this.toolbar.setSize(new Dimension(14, 14));
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.toolbar.add(separator);
        this.addToolbarButton("layout", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_Layout"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowViewController.this.layout();
            }
        });
        this.overviewButton = this.addToolbarButton("overview", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_Overview"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowViewController.this.overview();
            }
        });
        this.addToolbarButton("collapse-all", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_CollapseAll"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowViewController.this.collapseAll();
            }
        });
        this.addToolbarButton("expand-all", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_ExpandAll"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowViewController.this.expandAll();
            }
        });
        context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    private JButton addToolbarButton(String imageResourceName, String toolTipText, ActionListener listener) {
        JButton button = new JButton(ImageUtilities.loadImageIcon((String)("org/netbeans/modules/vmd/flow/resources/" + imageResourceName + ".png"), (boolean)false));
        button.setOpaque(false);
        button.setToolTipText(toolTipText);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        button.setSize(14, 14);
        button.addActionListener(listener);
        this.toolbar.add(button);
        return button;
    }

    private void layout() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                FlowAccessController accessController;
                FlowAccessController flowAccessController = accessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (accessController == null) {
                    return;
                }
                FlowScene scene = accessController.getScene();
                scene.layoutScene();
                scene.validate();
            }
        });
    }

    private void overview() {
        FlowAccessController accessController;
        DesignDocument doc = this.designDocument;
        FlowAccessController flowAccessController = accessController = doc != null ? (FlowAccessController)doc.getListenerManager().getAccessController(FlowAccessController.class) : null;
        if (accessController == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        popup.setLayout(new BorderLayout());
        JComponent sateliteView = accessController.createSatelliteView();
        popup.add((Component)sateliteView, "Center");
        popup.show(this.overviewButton, (this.overviewButton.getSize().width - sateliteView.getPreferredSize().width) / 2, this.overviewButton.getSize().height);
    }

    private void collapseAll() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                FlowAccessController accessController;
                FlowAccessController flowAccessController = accessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (accessController == null) {
                    return;
                }
                FlowScene scene = accessController.getScene();
                for (Object object : scene.getObjects()) {
                    Widget widget = scene.findWidget(object);
                    if (!(widget instanceof VMDMinimizeAbility)) continue;
                    ((VMDMinimizeAbility)widget).collapseWidget();
                }
            }
        });
    }

    private void expandAll() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                FlowAccessController accessController;
                FlowAccessController flowAccessController = accessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (accessController == null) {
                    return;
                }
                FlowScene scene = accessController.getScene();
                for (Object object : scene.getObjects()) {
                    Widget widget = scene.findWidget(object);
                    if (!(widget instanceof VMDMinimizeAbility)) continue;
                    ((VMDMinimizeAbility)widget).expandWidget();
                }
            }
        });
    }

    public JComponent getVisualRepresentation() {
        return this.visual;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public void setDesignDocument(final DesignDocument newDesignDocument) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                FlowViewController.this.designDocument = newDesignDocument;
                FlowAccessController accessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                FlowViewController.this.view = accessController != null ? accessController.getCreateView() : null;
                FlowViewController.this.visual.removeAll();
                if (FlowViewController.this.view != null) {
                    FlowViewController.this.view.putClientProperty("print.printable", Boolean.TRUE);
                    JScrollPane scroll = new JScrollPane(FlowViewController.this.view);
                    scroll.getHorizontalScrollBar().setUnitIncrement(64);
                    scroll.getHorizontalScrollBar().setBlockIncrement(256);
                    scroll.getVerticalScrollBar().setUnitIncrement(64);
                    scroll.getVerticalScrollBar().setBlockIncrement(256);
                    FlowViewController.this.visual.add((Component)scroll, "Center");
                    if (FlowViewController.this.visual.hasFocus()) {
                        FlowViewController.this.view.requestFocus();
                    }
                } else {
                    FlowViewController.this.visual.add((Component)FlowViewController.this.loadingPanel, "Center");
                }
                FlowViewController.this.visual.validate();
            }
        });
    }
}

