/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class SetMainProject
extends ProjectAction
implements Presenter.Menu,
PropertyChangeListener {
    private static final String namePattern = NbBundle.getMessage(SetMainProject.class, (String)"LBL_SetAsMainProjectAction_Name");
    private static final String PROJECT_KEY = "org.netbeans.modules.project.ui.MainProjectItem";
    protected JMenu subMenu;

    public SetMainProject() {
        this((Lookup)null);
    }

    public SetMainProject(Lookup context) {
        super(SetMainProject.class.getName(), namePattern, null, context);
        if (context == null) {
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        }
        this.refresh(this.getLookup());
    }

    @Override
    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects != null && projects.length > 0) {
            OpenProjectList.getDefault().setMainProject(projects[0]);
        }
    }

    @Override
    public void refresh(Lookup context) {
        super.refresh(context);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length != 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new SetMainProject(actionContext);
    }

    @Override
    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        Project[] projects = OpenProjectList.getDefault().getOpenProjects();
        Arrays.sort(projects, OpenProjectList.projectByDisplayName());
        if (projects == null || projects.length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (this.subMenu == null) {
            String label = NbBundle.getMessage(SetMainProject.class, (String)"LBL_SetMainProjectAction_Name");
            this.subMenu = new JMenu(label);
            this.subMenu.setMnemonic(NbBundle.getMessage(SetMainProject.class, (String)"MNE_SetMainProjectAction_Name").charAt(0));
            this.subMenu.putClientProperty(SetMainProject.class, this);
        }
        this.subMenu.removeAll();
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        JRadioButtonMenuItem jmiNone = new JRadioButtonMenuItem((Icon)null, false);
        Mnemonics.setLocalizedText((AbstractButton)jmiNone, (String)NbBundle.getMessage(SetMainProject.class, (String)"LBL_NoneMainProject_Name"));
        jmiNone.addActionListener(jmiActionListener);
        this.subMenu.add(jmiNone);
        this.subMenu.add(new JPopupMenu.Separator());
        for (int i = 0; i < projects.length; ++i) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)projects[i]);
            JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(pi.getDisplayName(), pi.getIcon(), false);
            this.subMenu.add(jmi);
            jmi.putClientProperty(PROJECT_KEY, projects[i]);
            jmi.addActionListener(jmiActionListener);
        }
        this.selectMainProject();
        this.subMenu.setEnabled(projects.length > 0);
    }

    private void selectMainProject() {
        boolean prjSelected = false;
        AbstractButton noneItem = null;
        for (int i = 0; i < this.subMenu.getItemCount(); ++i) {
            JMenuItem jmi = this.subMenu.getItem(i);
            if (jmi == null) continue;
            Project project = (Project)jmi.getClientProperty(PROJECT_KEY);
            if (project == null) {
                noneItem = (JRadioButtonMenuItem)jmi;
            }
            if (!(jmi instanceof JRadioButtonMenuItem)) continue;
            if (OpenProjectList.getDefault().isMainProject(project)) {
                ((JRadioButtonMenuItem)jmi).setSelected(true);
                prjSelected = true;
                continue;
            }
            ((JRadioButtonMenuItem)jmi).setSelected(false);
        }
        if (!prjSelected && noneItem != null) {
            noneItem.setSelected(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("OpenProjects".equals(e.getPropertyName())) {
            this.createSubMenu();
        } else if ("MainProject".equals(e.getPropertyName()) && this.subMenu != null) {
            this.selectMainProject();
        }
    }

    public static final class PopupWithoutContext
    extends SetMainProject
    implements Presenter.Popup {
        public PopupWithoutContext() {
        }

        private PopupWithoutContext(Lookup actionContext) {
            super(actionContext);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            this.subMenu = null;
            return this.getMenuPresenter();
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            return new PopupWithoutContext(actionContext);
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                Project project = (Project)jmi.getClientProperty(SetMainProject.PROJECT_KEY);
                OpenProjectList.getDefault().setMainProject(project);
            }
        }
    }
}

