/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileLineService {
    private static final boolean TRACE_READ_EXCEPTIONS = false;

    private CompileLineService() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Not enough parameters.");
            System.err.println("Usage:");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.CompileLineService -file binaryFileName");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.CompileLineService -folder folderName");
            return;
        }
        try {
            CompileLineService.dump(args[0], args[1], System.out);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void dump(String kind, String objFileName, PrintStream out) throws IOException, Exception {
        List<SourceFile> res = null;
        if ("-file".equals(kind)) {
            res = CompileLineService.getSourceFileProperties(objFileName);
        } else if ("-folder".equals(kind)) {
            res = CompileLineService.getSourceFolderProperties(objFileName);
        } else {
            throw new Exception("Wrong arguments: " + kind + " " + objFileName);
        }
        for (SourceFile entry : res) {
            out.println(entry.compileDir);
            out.println(entry.sourceFile);
            out.println(entry.compileLine);
        }
    }

    public static List<SourceFile> getSourceProperties(BufferedReader out) throws IOException {
        return CompileLineService.readSourceProperties(out);
    }

    private static List<SourceFile> readSourceProperties(BufferedReader out) throws IOException {
        String line;
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        String compileDir = null;
        String sourceFile = null;
        String compileLine = null;
        int i = 0;
        while ((line = out.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            switch (i % 3) {
                case 0: {
                    compileDir = line;
                    break;
                }
                case 1: {
                    sourceFile = line;
                    break;
                }
                case 2: {
                    compileLine = line;
                    list.add(new SourceFile(compileDir, sourceFile, compileLine));
                }
            }
            ++i;
        }
        return list;
    }

    public static List<SourceFile> getSourceFolderProperties(String objFolderName) {
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        for (String objFileName : CompileLineService.getObjectFiles(objFolderName)) {
            list.addAll(CompileLineService.getSourceFileProperties(objFileName));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SourceFile> getSourceFileProperties(String objFileName) {
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        Dwarf dump = null;
        try {
            dump = new Dwarf(objFileName);
            Iterator<CompilationUnit> iterator = dump.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                String lang;
                CompilationUnit cu = iterator.next();
                if (cu == null || cu.getRoot() == null || cu.getSourceFileName() == null || (lang = cu.getSourceLanguage()) == null || !LANG.DW_LANG_C.toString().equals(lang) && !LANG.DW_LANG_C89.toString().equals(lang) && !LANG.DW_LANG_C99.toString().equals(lang) && !LANG.DW_LANG_C_plus_plus.toString().equals(lang)) continue;
                list.add(new SourceFile(cu));
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (WrongFileFormatException ex) {
        }
        catch (IOException ex) {
        }
        catch (Exception exception) {
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
        return list;
    }

    private static Set<String> getObjectFiles(String root) {
        HashSet<String> set = new HashSet<String>();
        CompileLineService.gatherSubFolders(new File(root), set);
        HashSet<String> map = new HashSet<String>();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            File d = new File(it.next());
            if (!d.exists() || !d.isDirectory() || !d.canRead()) continue;
            File[] ff = d.listFiles();
            for (int i = 0; i < ff.length; ++i) {
                String name;
                if (!ff[i].isFile() || !(name = ff[i].getName()).endsWith(".o") && !name.endsWith(".so") && !name.endsWith(".a") && !CompileLineService.isExecutable(ff[i])) continue;
                String path = ff[i].getAbsolutePath();
                map.add(path);
            }
        }
        return map;
    }

    private static boolean isExecutable(File file) {
        String name = file.getName();
        return name.indexOf(46) < 0;
    }

    private static void gatherSubFolders(File d, HashSet<String> set) {
        if (d.exists() && d.isDirectory() && d.canRead()) {
            if (CompileLineService.ignoreFolder(d)) {
                return;
            }
            String path = d.getAbsolutePath();
            if (!set.contains(path)) {
                set.add(path);
                File[] ff = d.listFiles();
                for (int i = 0; i < ff.length; ++i) {
                    CompileLineService.gatherSubFolders(ff[i], set);
                }
            }
        }
    }

    private static boolean ignoreFolder(File file) {
        if (file.isDirectory()) {
            String name = file.getName();
            return name.equals("SCCS") || name.equals("CVS") || name.equals(".hg") || name.equals("SunWS_cache") || name.equals(".svn");
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SourceFile {
        private final String compileLine;
        private final String compileDir;
        private final String sourceFile;
        private Map<String, String> userMacros;
        private List<String> userPaths;

        private SourceFile(CompilationUnit cu) throws IOException, Exception {
            String s = cu.getCommandLine();
            if (s == null) {
                throw new Exception("Dwarf information does not contain compile line");
            }
            this.compileLine = s.trim();
            this.compileDir = cu.getCompilationDir();
            if (this.compileDir == null) {
                throw new Exception("Dwarf information does not contain compile dir");
            }
            this.sourceFile = cu.getSourceFileName();
            if (this.sourceFile == null) {
                throw new Exception("Dwarf information does not contain source file name");
            }
        }

        private SourceFile(String compileDir, String sourceFile, String compileLine) {
            this.compileLine = compileLine;
            this.compileDir = compileDir;
            this.sourceFile = sourceFile;
        }

        public final String getCompileDir() {
            return this.compileDir;
        }

        public final String getSource() {
            return this.sourceFile;
        }

        public final String getCompileLine() {
            return this.compileLine;
        }

        public final Map<String, String> getUserMacros() {
            if (this.userMacros == null) {
                this.initMacrosAndPaths();
            }
            return this.userMacros;
        }

        public final List<String> getUserPaths() {
            if (this.userPaths == null) {
                this.initMacrosAndPaths();
            }
            return this.userPaths;
        }

        private void initMacrosAndPaths() {
            this.userPaths = new ArrayList<String>();
            this.userMacros = new LinkedHashMap<String, String>();
            Iterator<String> st = this.splitCommandLine(this.compileLine).iterator();
            while (st.hasNext()) {
                String path;
                String option = st.next();
                if (option.startsWith("-D")) {
                    String macro = option.substring(2);
                    int i = macro.indexOf(61);
                    if (i > 0) {
                        String value = macro.substring(i + 1).trim();
                        if (value.length() >= 2 && (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'' || value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"')) {
                            value = value.substring(1, value.length() - 1);
                        }
                        this.userMacros.put(macro.substring(0, i), value);
                        continue;
                    }
                    this.userMacros.put(macro, null);
                    continue;
                }
                if (option.startsWith("-I")) {
                    path = option.substring(2);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    this.userPaths.add(path);
                    continue;
                }
                if (option.startsWith("-Y")) {
                    String defaultSearchPath = option.substring(2);
                    if (defaultSearchPath.length() == 0 && st.hasNext()) {
                        defaultSearchPath = st.next();
                    }
                    if (!defaultSearchPath.startsWith("I,")) continue;
                    defaultSearchPath = defaultSearchPath.substring(2);
                    this.userPaths.add(defaultSearchPath);
                    continue;
                }
                if (option.startsWith("-isystem")) {
                    path = option.substring(8);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    this.userPaths.add(path);
                    continue;
                }
                if (option.startsWith("-include")) {
                    path = option.substring(8);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    this.userPaths.add(path);
                    continue;
                }
                if (!option.startsWith("-imacros")) continue;
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                this.userPaths.add(path);
            }
        }

        private List<String> splitCommandLine(String line) {
            ArrayList<String> res = new ArrayList<String>();
            int i = 0;
            StringBuilder current = new StringBuilder();
            boolean isSingleQuoteMode = false;
            boolean isDoubleQuoteMode = false;
            block5: while (i < line.length()) {
                char c = line.charAt(i);
                ++i;
                switch (c) {
                    case '\'': {
                        if (isSingleQuoteMode) {
                            isSingleQuoteMode = false;
                        } else if (!isDoubleQuoteMode) {
                            isSingleQuoteMode = true;
                        }
                        current.append(c);
                        continue block5;
                    }
                    case '\"': {
                        if (isDoubleQuoteMode) {
                            isDoubleQuoteMode = false;
                        } else if (!isSingleQuoteMode) {
                            isDoubleQuoteMode = true;
                        }
                        current.append(c);
                        continue block5;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (isSingleQuoteMode || isDoubleQuoteMode) {
                            current.append(c);
                            continue block5;
                        }
                        if (current.length() <= 0) continue block5;
                        res.add(current.toString());
                        current.setLength(0);
                        continue block5;
                    }
                }
                current.append(c);
            }
            if (current.length() > 0) {
                res.add(current.toString());
            }
            return res;
        }
    }
}

