/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class ConcatFunction
extends SimpleNode {
    public ConcatFunction(int id) {
        super(id);
    }

    public ConcatFunction(Parser p, int id) {
        super(p, id);
    }

    public String toNormalizedString() {
        boolean first = true;
        String normalized = "concat(";
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                if (!first) {
                    normalized = normalized + ",";
                }
                first = false;
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    normalized = normalized + n.toNormalizedString();
                }
                ++i;
            }
        }
        normalized = normalized + ")";
        return normalized;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        StringBuffer buff = new StringBuffer();
        try {
            int i = 0;
            while (i < this.jjtGetNumChildren()) {
                buff.append(Convert.toString(this.jjtGetChild(i).evaluate(pageContext, icontext)));
                ++i;
            }
        }
        catch (ConversionException ce) {
            throw new EvaluationException(this, ce.getMessage());
        }
        return buff.toString();
    }
}

