/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SaveQueryPanel
extends JPanel
implements DocumentListener {
    private static JButton ok;
    private DialogDescriptor descriptor;
    private QueryNameValidator validator;
    private static final Color ERROR_COLOR;
    private JLabel jLabel3;
    final JTextField queryNameTextField = new JTextField();
    final JLabel saveErrorLabel = new JLabel();

    private SaveQueryPanel() {
        this.initComponents();
        this.queryNameTextField.getDocument().addDocumentListener(this);
        this.saveErrorLabel.setForeground(ERROR_COLOR);
        Image img = ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/error.gif");
        this.saveErrorLabel.setIcon(new ImageIcon(img));
        this.saveErrorLabel.setVisible(false);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SaveQueryPanel.class, (String)"SaveQueryPanel.jLabel3.text"));
        this.saveErrorLabel.setText(NbBundle.getMessage(SaveQueryPanel.class, (String)"SaveQueryPanel.saveErrorLabel.text_1"));
        this.queryNameTextField.setColumns(18);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.saveErrorLabel, -1, 436, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.queryNameTextField, -1, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.queryNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.saveErrorLabel, -2, 17, -2).addContainerGap(34, Short.MAX_VALUE)));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validatePanel();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validatePanel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validatePanel();
    }

    private void validatePanel() {
        String name = this.queryNameTextField.getText();
        String errText = this.validator.isValid(name);
        boolean valid = !name.equals("") && errText == null;
        ok.setEnabled(valid);
        if (errText != null) {
            this.saveErrorLabel.setText(errText);
            this.saveErrorLabel.setVisible(true);
        } else {
            this.saveErrorLabel.setText("");
            this.saveErrorLabel.setVisible(false);
        }
    }

    public static String show(QueryNameValidator validator, HelpCtx helpCtx) {
        SaveQueryPanel panel = new SaveQueryPanel();
        panel.validator = validator;
        if (panel.descriptor == null) {
            ok = new JButton(NbBundle.getMessage(SaveQueryPanel.class, (String)"LBL_Save"));
            ok.getAccessibleContext().setAccessibleDescription(ok.getText());
            JButton cancel = new JButton(NbBundle.getMessage(SaveQueryPanel.class, (String)"LBL_Cancel"));
            cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
            panel.descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(SaveQueryPanel.class, (String)"LBL_SaveQuery"), true, new Object[]{ok, cancel}, (Object)ok, 0, helpCtx, null);
        }
        panel.validatePanel();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)panel.descriptor) == ok) {
            return panel.queryNameTextField.getText();
        }
        return null;
    }

    static {
        ERROR_COLOR = new Color(153, 0, 0);
    }

    public static abstract class QueryNameValidator {
        public abstract String isValid(String var1);
    }
}

