/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod.edit;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.coderefactoring.extractmethod.request.ExtractMethodRequest;
import org.python.pydev.refactoring.core.edit.AbstractReplaceEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractCallEdit
extends AbstractReplaceEdit {
    private String methodName;
    private int offset;
    private IASTNodeAdapter<?> offsetAdapter;
    private int replaceLength;
    private List<String> callParameters;
    private List<String> returnVariables;

    public ExtractCallEdit(ExtractMethodRequest req) {
        super(req);
        this.methodName = req.getMethodName();
        this.offset = req.getSelection().getOffset();
        this.replaceLength = req.getSelection().getLength();
        this.offsetAdapter = req.getOffsetNode();
        this.callParameters = req.getParameters();
        this.returnVariables = req.getReturnVariables();
    }

    @Override
    protected SimpleNode getEditNode() {
        List<exprType> argsList = this.initCallArguments();
        Call methodCall = new Call(this.createCallAttribute(), argsList.toArray(new exprType[0]), null, null, null);
        return this.initSubstituteCall(methodCall);
    }

    private SimpleNode initSubstituteCall(Call methodCall) {
        if (this.returnVariables.size() == 0) {
            return methodCall;
        }
        ArrayList<Name> returnExpr = new ArrayList<Name>();
        for (String returnVar : this.returnVariables) {
            returnExpr.add(new Name(returnVar, 2, false));
        }
        return new Assign(returnExpr.toArray(new exprType[0]), (exprType)methodCall);
    }

    private List<exprType> initCallArguments() {
        ArrayList<exprType> argsList = new ArrayList<exprType>();
        for (String parameter : this.callParameters) {
            argsList.add((exprType)new Name(parameter, 1, false));
        }
        return argsList;
    }

    private exprType createCallAttribute() {
        if (this.offsetAdapter instanceof IClassDefAdapter) {
            return new Attribute((exprType)new Name("self", 1, false), (NameTokType)new NameTok(this.methodName, 8), 1);
        }
        return new Name(this.methodName, 1, false);
    }

    @Override
    public int getOffsetStrategy() {
        return 0;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    protected int getReplaceLength() {
        return this.replaceLength;
    }
}

