/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email;

import au.com.trgtd.email.EmailUtils;
import au.com.trgtd.email.prefs.EmailPrefs;
import au.com.trgtd.email.utils.Renderable;
import au.com.trgtd.email.utils.RenderableFactory;
import java.util.Date;
import java.util.logging.Logger;
import javax.mail.Message;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.thought.Thought;
import tr.util.Observable;

public class Email {
    private static final Logger LOG = Logger.getLogger("tr.email");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retrieve() {
        LOG.info("Starting email fetch at: " + new Date());
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        EmailUtils email = new EmailUtils();
        try {
            String username = EmailPrefs.getEmailUsername();
            String password = EmailPrefs.getEmailPassword();
            String popserver = EmailPrefs.getEmailServer();
            int port = EmailPrefs.getPort();
            boolean ssl = EmailPrefs.isSSL();
            LOG.info("Username:" + username);
            LOG.info("POP Server:" + popserver);
            LOG.info("Port:" + port);
            LOG.info("SSL:" + ssl);
            email.setUserPass(username, password);
            email.setServer(popserver);
            email.setPort(port);
            email.setUseSSL(ssl);
            email.connect();
            email.openFolder("INBOX");
            LOG.info("Total messages: " + email.getMessageCount());
            for (Message msg : email.getNewMessages()) {
                Renderable r = RenderableFactory.create(msg);
                if (r != null) {
                    Email.createThought(data, r.getSubject(), r.getBodytext());
                }
                email.delete(msg);
            }
            email.closeFolder(true);
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
            e.printStackTrace();
            return;
        }
        finally {
            try {
                email.disconnect();
            }
            catch (Exception exception) {}
        }
        LOG.info("Finished email fetch at: " + new Date());
    }

    private static void createThought(Data data, String subject, String body) {
        Thought thought = new Thought(data.getNextID());
        thought.setDescription(subject);
        thought.setNotes(body);
        data.getThoughtManager().add((Observable)thought);
    }
}

