/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.host;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.host.HostForm;

public final class SaveHostAction
extends Action {
    private String[] createStandardHostTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "boolean", "boolean", "boolean", "boolean", "boolean"};
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        HostForm hform = (HostForm)form;
        String adminAction = hform.getAdminAction();
        String hObjectName = hform.getObjectName();
        ObjectName honame = null;
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String serviceName = hform.getServiceName();
                ObjectName soname = new ObjectName(serviceName);
                String domain = soname.getDomain();
                ObjectName oname = new ObjectName(domain + ":type=Host" + ",host=" + hform.getHostName());
                if (this.mBServer.isRegistered(oname)) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("hostName", new ActionMessage("error.hostName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new Object[]{domain + ":type=Engine", hform.getHostName(), hform.getAppBase(), new Boolean(hform.getAutoDeploy()), new Boolean(hform.getDeployOnStartup()), new Boolean(hform.getDeployXML()), new Boolean(hform.getUnpackWARs()), new Boolean(hform.getXmlNamespaceAware()), new Boolean(hform.getXmlValidation())};
                operation = "createStandardHost";
                hObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardHostTypes);
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    String parentName = serviceName;
                    TreeControlNode parentNode = control.findNode(parentName);
                    if (parentNode != null) {
                        String nodeLabel = resources.getMessage(locale, "server.service.treeBuilder.host") + " (" + hform.getHostName() + ")";
                        String encodedName = URLEncoder.encode(hObjectName, "UTF-8");
                        TreeControlNode childNode = new TreeControlNode(hObjectName, "Host.gif", nodeLabel, "EditHost.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parentName + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            honame = new ObjectName(hObjectName);
            attribute = "appBase";
            String appBase = "";
            try {
                appBase = hform.getAppBase();
            }
            catch (Throwable t) {
                appBase = "";
            }
            this.mBServer.setAttribute(honame, new Attribute("appBase", appBase));
            attribute = "autoDeploy";
            String autoDeploy = "true";
            try {
                autoDeploy = hform.getAutoDeploy();
            }
            catch (Throwable t) {
                autoDeploy = "true";
            }
            this.mBServer.setAttribute(honame, new Attribute("autoDeploy", new Boolean(autoDeploy)));
            attribute = "deployXML";
            String deployXML = "true";
            try {
                deployXML = hform.getDeployXML();
            }
            catch (Throwable t) {
                deployXML = "true";
            }
            this.mBServer.setAttribute(honame, new Attribute("deployXML", new Boolean(deployXML)));
            attribute = "deployOnStartup";
            String deployOnStartup = "true";
            try {
                deployOnStartup = hform.getDeployOnStartup();
            }
            catch (Throwable t) {
                deployOnStartup = "true";
            }
            this.mBServer.setAttribute(honame, new Attribute("deployOnStartup", new Boolean(deployOnStartup)));
            attribute = "unpackWARs";
            String unpackWARs = "false";
            try {
                unpackWARs = hform.getUnpackWARs();
            }
            catch (Throwable t) {
                unpackWARs = "false";
            }
            this.mBServer.setAttribute(honame, new Attribute("unpackWARs", new Boolean(unpackWARs)));
            attribute = "xmlNamespaceAware";
            String xmlNamespaceAware = "false";
            try {
                xmlNamespaceAware = hform.getXmlNamespaceAware();
            }
            catch (Throwable t) {
                xmlNamespaceAware = "false";
            }
            this.mBServer.setAttribute(honame, new Attribute("xmlNamespaceAware", new Boolean(xmlNamespaceAware)));
            attribute = "xmlValidation";
            String xmlValidation = "false";
            try {
                xmlValidation = hform.getXmlValidation();
            }
            catch (Throwable t) {
                xmlValidation = "false";
            }
            this.mBServer.setAttribute(honame, new Attribute("xmlValidation", new Boolean(xmlValidation)));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

