/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAccessible.idl
 */

#ifndef __gen_nsIAccessible_h__
#define __gen_nsIAccessible_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIAccessible */
#define NS_IACCESSIBLE_IID_STR "db717db4-37e9-42f1-a3b0-2579dd7c3814"

#define NS_IACCESSIBLE_IID \
  {0xdb717db4, 0x37e9, 0x42f1, \
    { 0xa3, 0xb0, 0x25, 0x79, 0xdd, 0x7c, 0x38, 0x14 }}

/**
 * A cross-platform interface that supports platform-specific 
 * accessibility APIs like MSAA and ATK. Contains the sum of what's needed
 * to support IAccessible as well as ATK's generic accessibility objects.
 * Can also be used by in-process accessibility clients to get information
 * about objects in the accessible tree. The accessible tree is a subset of 
 * nodes in the DOM tree -- such as documents, focusable elements and text.
 * Mozilla creates the implementations of nsIAccessible on demand.
 * See http://www.mozilla.org/projects/ui/accessibility for more information.
 *
 * @status UNDER_REVIEW
 */
class nsIAccessible : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IACCESSIBLE_IID)

  /**
   * Parent node in accessible tree.
   */
  /* readonly attribute nsIAccessible parent; */
  NS_IMETHOD GetParent(nsIAccessible * *aParent) = 0;

  /**
   * Next sibling in accessible tree
   */
  /* readonly attribute nsIAccessible nextSibling; */
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) = 0;

  /**
   * Previous sibling in accessible tree
   */
  /* readonly attribute nsIAccessible previousSibling; */
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) = 0;

  /**
   * First child in accessible tree
   */
  /* readonly attribute nsIAccessible firstChild; */
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) = 0;

  /**
   * Last child in accessible tree
   */
  /* readonly attribute nsIAccessible lastChild; */
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) = 0;

  /**
   * Number of accessible children
   */
  /* readonly attribute long childCount; */
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) = 0;

  /**
   * The 0-based index of this accessible in its parent's list of children,
   * or -1 if this accessible does not have a parent.
   */
  /* readonly attribute long indexInParent; */
  NS_IMETHOD GetIndexInParent(PRInt32 *aIndexInParent) = 0;

  /**
   * Accessible name -- the main text equivalent for this node
   */
  /* attribute AString name; */
  NS_IMETHOD GetName(nsAString & aName) = 0;
  NS_IMETHOD SetName(const nsAString & aName) = 0;

  /**
   * Accessible value -- a number or a secondary text equivalent for this node
   * Widgets that use a role attribute can force a value using the valuenow attribute
   */
  /* readonly attribute AString finalValue; */
  NS_IMETHOD GetFinalValue(nsAString & aFinalValue) = 0;

  /**
   * Accessible description -- long text associated with this node
   */
  /* readonly attribute AString description; */
  NS_IMETHOD GetDescription(nsAString & aDescription) = 0;

  /**
   * Provides localized string of accesskey name, such as Alt+D.
   * The modifier may be affected by user and platform preferences.
   * Usually alt+letter, or just the letter alone for menu items. 
   */
  /* readonly attribute AString keyboardShortcut; */
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) = 0;

  /**
   * Provides localized string of global keyboard accelerator, such
   * as Ctrl+O for Open file
   */
  /* readonly attribute AString keyBinding; */
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) = 0;

  /**
   * Natural enumerated accessible role for the associated element.
   * The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * This does not take into account role attribute as the finalRole does.
   */
  /* readonly attribute unsigned long role; */
  NS_IMETHOD GetRole(PRUint32 *aRole) = 0;

  /**
   * Enumerated accessible role. The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * Widgets can use role attribute to force the final role
   */
  /* readonly attribute unsigned long finalRole; */
  NS_IMETHOD GetFinalRole(PRUint32 *aFinalRole) = 0;

  /**
   * Accessible states -- bit field which describes boolean properties of node. 
   * See the STATE_* constants defined later in this file.
   * Many states are only valid given a certain role attribute that supports them
   */
  /* readonly attribute unsigned long finalState; */
  NS_IMETHOD GetFinalState(PRUint32 *aFinalState) = 0;

  /**
   * Extended accessible states -- second bit field describing node
   */
  /* readonly attribute unsigned long extState; */
  NS_IMETHOD GetExtState(PRUint32 *aExtState) = 0;

  /**
   * Help text associated with node
   */
  /* readonly attribute AString help; */
  NS_IMETHOD GetHelp(nsAString & aHelp) = 0;

  /**
   * Focused accessible child of node
   */
  /* readonly attribute nsIAccessible focusedChild; */
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) = 0;

  /**
   * Accessible child which contains the coordinate at x,y
   */
  /* nsIAccessible getChildAtPoint (in long x, in long y); */
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) = 0;

  /**
   * Nth accessible child using zero-based index or last child if index less than zero
   */
  /* nsIAccessible getChildAt (in long aChildIndex); */
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically to the right of this one
   */
  /* nsIAccessible getAccessibleToRight (); */
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically to the left of this one
   */
  /* nsIAccessible getAccessibleToLeft (); */
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically above this one
   */
  /* nsIAccessible getAccessibleAbove (); */
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) = 0;

  /**
   * Accessible node geometrically below this one
   */
  /* nsIAccessible getAccessibleBelow (); */
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) = 0;

  /**
   * Accessible node related to this one 
   */
  /* nsIAccessible getAccessibleRelated (in unsigned long aRelationType); */
  NS_IMETHOD GetAccessibleRelated(PRUint32 aRelationType, nsIAccessible **_retval) = 0;

  /* void getBounds (out long x, out long y, out long width, out long height); */
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) = 0;

  /**
   * Add this accessible to the current selection
   */
  /* void addSelection (); */
  NS_IMETHOD AddSelection(void) = 0;

  /**
   * Remove this accessible from the current selection
   */
  /* void removeSelection (); */
  NS_IMETHOD RemoveSelection(void) = 0;

  /**
   * Extend the current selection from its current accessible anchor node
   * to this accessible
   */
  /* void extendSelection (); */
  NS_IMETHOD ExtendSelection(void) = 0;

  /**
   * Select this accessible node only
   */
  /* void takeSelection (); */
  NS_IMETHOD TakeSelection(void) = 0;

  /**
   * Focus this accessible node,
   * The state STATE_FOCUSABLE indicates whether this node is normally focusable.
   * It is the callers responsibility to determine whether this node is focusable.
   * accTakeFocus on a node that is not normally focusable (such as a table),
   * will still set focus on that node, although normally that will not be visually 
   * indicated in most style sheets.
   */
  /* void takeFocus (); */
  NS_IMETHOD TakeFocus(void) = 0;

  /**
   * The number of accessible actions associated with this accessible
   */
  /* readonly attribute PRUint8 numActions; */
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) = 0;

  /**
   * The name of the accessible action at the given zero-based index
   */
  /* AString getActionName (in PRUint8 index); */
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) = 0;

  /**
   * Perform the accessible action at the given zero-based index
   * Action number 0 is the default action
   */
  /* void doAction (in PRUint8 index); */
  NS_IMETHOD DoAction(PRUint8 index) = 0;

  /**
   * Get a pointer to accessibility interface for this node, which is specific 
   * to the OS/accessibility toolkit we're running on.
   */
  /* [noscript] void getNativeInterface (out voidPtr aOutAccessible); */
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) = 0;

  /**
   * MSAA State flags - used for bitfield. More than 1 allowed.
   */
  enum { STATE_UNAVAILABLE = 1U };

  enum { STATE_SELECTED = 2U };

  enum { STATE_FOCUSED = 4U };

  enum { STATE_PRESSED = 8U };

  enum { STATE_CHECKED = 16U };

  enum { STATE_MIXED = 32U };

  enum { STATE_READONLY = 64U };

  enum { STATE_HOTTRACKED = 128U };

  enum { STATE_DEFAULT = 256U };

  enum { STATE_EXPANDED = 512U };

  enum { STATE_COLLAPSED = 1024U };

  enum { STATE_BUSY = 2048U };

  enum { STATE_FLOATING = 4096U };

  enum { STATE_MARQUEED = 8192U };

  enum { STATE_ANIMATED = 16384U };

  enum { STATE_INVISIBLE = 32768U };

  enum { STATE_OFFSCREEN = 65536U };

  enum { STATE_SIZEABLE = 131072U };

  enum { STATE_MOVEABLE = 262144U };

  enum { STATE_SELFVOICING = 524288U };

  enum { STATE_FOCUSABLE = 1048576U };

  enum { STATE_SELECTABLE = 2097152U };

  enum { STATE_LINKED = 4194304U };

  enum { STATE_TRAVERSED = 8388608U };

  enum { STATE_MULTISELECTABLE = 16777216U };

  enum { STATE_EXTSELECTABLE = 33554432U };

  enum { STATE_ALERT_LOW = 67108864U };

  enum { STATE_ALERT_MEDIUM = 134217728U };

  enum { STATE_ALERT_HIGH = 268435456U };

  enum { STATE_PROTECTED = 536870912U };

  enum { STATE_HASPOPUP = 1073741824U };

  enum { STATE_REQUIRED = 67108864U };

  enum { STATE_IMPORTANT = 134217728U };

  enum { STATE_INVALID = 268435456U };

  enum { STATE_CHECKABLE = 8192U };

  /**
 * Extended state flags (for now non-MSAA, for Java and Gnome/ATK support)
 * "Extended state flags" has seperate value space from "MSAA State flags".
 */
  enum { EXT_STATE_EDITABLE = 2097152U };

  enum { EXT_STATE_ACTIVE = 4194304U };

  enum { EXT_STATE_EXPANDABLE = 8388608U };

  enum { EXT_STATE_MODAL = 16777216U };

  enum { EXT_STATE_MULTI_LINE = 33554432U };

  enum { EXT_STATE_SENSITIVE = 67108864U };

  enum { EXT_STATE_SHOWING = 268435456U };

  enum { EXT_STATE_SINGLE_LINE = 536870912U };

  enum { EXT_STATE_TRANSIENT = 1073741824U };

  enum { EXT_STATE_VERTICAL = 2147483648U };

  /**
 * Relation Types -- most of these come from ATK's atkrelationtype.h
 * RELATION_NULL:
 * RELATION_CONTROLLED_BY:    Controlled by one or more target objects.
 * RELATION_CONTROLLER_FOR:   Controller for one or more target objects.
 * RELATION_LABEL_FOR:        Label for one or more target objects.
 * RELATION_LABELLED_BY:      Labelled by one or more target objects.
 * RELATION_MEMBER_OF:        Member of a group of one or more target objects.
 * RELATION_NODE_CHILD_OF:    Cell in a treetable which is displayed because a
 *                            cell in the same col is expanded & identifies it.
 * RELATION_FLOWS_TO:         Has content that flows logically to another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_FLOWS_FROM:       Has content that flows logically from another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_SUBWINDOW_OF:     Subwindow attached to a component but otherwise 
 *                            not connected in the UI hierarchy to that component.
 * RELATION_EMBEDS:           Visually embeds another object's content, i.e.
 *                            this object's content flows around another's content.
 * RELATION_EMBEDDED_BY:      Inverse of RELATION_EMBEDS; this object's content
 *                            is visually embedded in another object.
 * RELATION_POPUP_FOR:        Popup for another object.
 * RELATION_PARENT_WINDOW_OF: Parent window of another object.
 * RELATION_DEFAULT_BUTTON:   Part of a form/dialog with a related default button.
 * RELATION_DESCRIBED_BY:     Described by one or more target objects.
 * RELATION_DESCRIPTION_FOR:  Description for one or more target objects.
 * RELATION_LAST_DEFINED:
 */
  enum { RELATION_NUL = 0U };

  enum { RELATION_CONTROLLED_BY = 1U };

  enum { RELATION_CONTROLLER_FOR = 2U };

  enum { RELATION_LABEL_FOR = 3U };

  enum { RELATION_LABELLED_BY = 4U };

  enum { RELATION_MEMBER_OF = 5U };

  enum { RELATION_NODE_CHILD_OF = 6U };

  enum { RELATION_FLOWS_TO = 7U };

  enum { RELATION_FLOWS_FROM = 8U };

  enum { RELATION_SUBWINDOW_OF = 9U };

  enum { RELATION_EMBEDS = 10U };

  enum { RELATION_EMBEDDED_BY = 11U };

  enum { RELATION_POPUP_FOR = 12U };

  enum { RELATION_PARENT_WINDOW_OF = 13U };

  enum { RELATION_DEFAULT_BUTTON = 16384U };

  enum { RELATION_DESCRIBED_BY = 16385U };

  enum { RELATION_DESCRIPTION_FOR = 16386U };

#ifdef MOZ_ACCESSIBILITY_ATK
  enum { RELATION_LAST_DEFINED = 14U };
/**
 * The following nsIAccessible roles are translated to ATK_ROLE_UNKNOWN
 * 
 *  ROLE_TITLEBAR, ROLE_SOUND, ROLE_CURSOR, ROLE_CARET, ROLE_BORDER,
 *  ROLE_GROUPING, ROLE_EQUATION, ROLE_COLUMN, ROLE_ROW, ROLE_LINK,
 *  ROLE_WHITESPACE, ROLE_CLOCK, ROLE_IPADDRESS, ROLE_NOTHING
 *
 *  ROLE_GRIP
 *    The object represents a special mouse pointer, which allows a user to
 *    manipulate user interface elements such as windows.
 *
 *  ROLE_HELPBALLOON
 *    The object displays a Help topic in the form of a ToolTip or Help balloon.
 *
 *  ROLE_PROPERTYPAGE
 *    The object represents a property sheet.
 *
 *  ROLE_INDICATOR
 *    The object represents an indicator, such as a pointer graphic pointing to
 *    the current item.
 *
 *  ROLE_HOTKEYFIELD
 *    The object represents a hot-key field that allow the user to enter a
 *    sequence of keystroke.
 *
 * The following ATK roles have no corresponding nsIAccessible roles. Perhaps
 * there are not these types of widget/control in Mozilla, so don't need these
 * ATK roles? Or need add some of them?
 *
 *   ATK_ROLE_ARROW
 *     An arrow in one of the four cardinal directions.
 *
 *   ATK_ROLE_INTERNAL_FRAME
 *     A frame-like object that is clipped by a desktop pane.
 * 
 *  ATK_ROLE_ACCEL_LABEL, ATK_ROLE_CANVAS, ATK_ROLE_CHECK_MENU_ITEM,
 *   ATK_ROLE_COLOR_CHOOSER, ATK_ROLE_DATE_EDITOR, ATK_ROLE_DESKTOP_ICON,
 *   ATK_ROLE_DESKTOP_FRAME, ATK_ROLE_DIRECTORY_PANE, ATK_ROLE_FILE_CHOOSER,
 *   ATK_ROLE_FILLER, ATK_ROLE_FONT_CHOOSER, ATK_ROLE_GLASS_PANE,
 *  ATK_ROLE_HTML_CONTAINER, ATK_ROLE_ICON, ATK_ROLE_LAYERED_PANE,
 *   ATK_ROLE_POPUP_MENU, ATK_ROLE_OPTION_PANE, ATK_ROLE_PASSWORD_TEXT,
 *  ATK_ROLE_RADIO_MENU_ITEM, ATK_ROLE_ROOT_PANE, ATK_ROLE_SCROLL_PANE,
 *  ATK_ROLE_SPLIT_PANE, ATK_ROLE_TEAR_OFF_MENU_ITEM, ATK_ROLE_TERMINAL,
 *  ATK_ROLE_TOGGLE_BUTTON, ATK_ROLE_TREE_TABLE, ATK_ROLE_VIEWPORT, ATK_ROLE_LABEL
 *
 * Important:
 * Following value should keep synchronization with the definitions in atk.h
 */
  enum { ROLE_TITLEBAR = 66U };    // ATK_ROLE_UNKNOWN
  enum { ROLE_MENUBAR = 33U };     // ATK_ROLE_MENU_BAR
  enum { ROLE_SCROLLBAR = 47U };   // ATK_ROLE_SCROLL_BAR
  enum { ROLE_GRIP = 66U };        // ATK_ROLE_UNKNOWN
  enum { ROLE_SOUND = 66U };       // ATK_ROLE_UNKNOWN
  enum { ROLE_CURSOR = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_CARET = 66U };       // ATK_ROLE_UNKNOWN
  enum { ROLE_ALERT = 2U };        // ATK_ROLE_ALERT
  enum { ROLE_WINDOW = 68U };      // ATK_ROLE_WINDOW
  // An object used for drawing custom user interface elements
  enum { ROLE_CLIENT = 18U };      // ATK_ROLE_DRAWING_AREA
  enum { ROLE_MENUPOPUP = 32U };   // ATK_ROLE_MENU
  enum { ROLE_MENUITEM = 34U };    // ATK_ROLE_MENU_ITEM
  enum { ROLE_TOOLTIP = 63U };     // ATK_ROLE_TOOL_TIP
  // The object represents a main window for a application
  enum { ROLE_APPLICATION = 73U }; // ATK_ROLE_APPLICATION
  // The object represents a document window, only for MDI windows
  enum { ROLE_DOCUMENT = 80U };    // ATK_ROLE_DOCUMENT_FRAME
  enum { ROLE_PANE = 38U };        // ATK_ROLE_PANEL
  enum { ROLE_CHART = 78U };       // ATK_ROLE_CHART
  enum { ROLE_DIALOG = 16U };      // ATK_ROLE_DIALOG
  enum { ROLE_BORDER = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_GROUPING = 38U };    // ATK_ROLE_PANEL
  enum { ROLE_SEPARATOR = 49U };   // ATK_ROLE_SEPARATOR
  enum { ROLE_TOOLBAR = 62U };     // ATK_ROLE_TOOL_BAR
  enum { ROLE_STATUSBAR = 53U };   // ATK_ROLE_STATUSBAR
  enum { ROLE_TABLE = 54U };       // ATK_ROLE_TABLE
  // Or ATK_ROLE_TABLE_COLUMN_HEADER?
  enum { ROLE_COLUMNHEADER = 10U };// ATK_ROLE_COLUMN_HEADER
  // Or ATK_ROLE_TABLE_ROW_HEADER ?
  enum { ROLE_ROWHEADER = 46U };   // ATK_ROLE_ROW_HEADER
  enum { ROLE_COLUMN = 66U };      // ATK_ROLE_UNKNOWN
  enum { ROLE_ROW = 66U };         // ATK_ROLE_UNKNOWN
  enum { ROLE_CELL = 55U };        // ATK_ROLE_TABLE_CELL
  enum { ROLE_LINK = 101U };        // ATK doesn't have such role now
  enum { ROLE_HELPBALLOON = 66U }; // ATK_ROLE_UNKNOWN
  // The object represents a cartoon-like graphic object
  enum { ROLE_CHARACTER = 26U };   // ATK_ROLE_IMAGE
  enum { ROLE_LIST = 30U };        // ATK_ROLE_LIST
  enum { ROLE_LISTITEM = 31U };    // ATK_ROLE_LIST_ITEM
  // The object represents an outline or tree structure
  enum { ROLE_OUTLINE = 64U };     // ATK_ROLE_TREE
  // The object represents an item in an outline or tree structure
  enum { ROLE_OUTLINEITEM = 31U }; // ATK_ROLE_LIST_ITEM
  enum { ROLE_PAGETAB = 36U };     // ATK_ROLE_PAGE_TAB
  enum { ROLE_PROPERTYPAGE = 66U };// ATK_ROLE_UNKNOWN
  enum { ROLE_INDICATOR = 66U };   // ATK_ROLE_UNKNOWN
  enum { ROLE_GRAPHIC = 26U };     // ATK_ROLE_IMAGE
  // Read-only text, can't be modified or selected
  enum { ROLE_STATICTEXT = 60U };  // ATK_ROLE_TEXT
  enum { ROLE_TEXT = 60U };        // ATK_ROLE_TEXT
  enum { ROLE_PUSHBUTTON = 42U };  // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_CHECKBUTTON = 7U };  // ATK_ROLE_CHECK_BOX
  enum { ROLE_RADIOBUTTON = 43U }; // ATK_ROLE_RADIO_BUTTON
  enum { ROLE_COMBOBOX = 11U };    // ATK_ROLE_COMBO_BOX
  // Just represents the calender control
  enum { ROLE_DROPLIST = 5U };     // ATK_ROLE_CALENDAR
  enum { ROLE_PROGRESSBAR = 41U }; // ATK_ROLE_PROGRESS_BAR
  enum { ROLE_DIAL = 15U };        // ATK_ROLE_DIAL
  enum { ROLE_HOTKEYFIELD = 66U }; // ATK_ROLE_UNKNOWN
  enum { ROLE_SLIDER = 50U };      // ATK_ROLE_SLIDER
  enum { ROLE_SPINBUTTON = 52U };  // ATK_ROLE_SPIN_BUTTON
  enum { ROLE_DIAGRAM = 26U };     // ATK_ROLE_IMAGE
  enum { ROLE_ANIMATION = 3U };    // ATK_ROLE_ANIMATION
  enum { ROLE_EQUATION = 66U };    // ATK_ROLE_UNKNOWN
  enum { ROLE_BUTTONDROPDOWN = 42U }; // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_BUTTONMENU = 42U };  // ATK_ROLE_PUSH_BUTTON
  // Represents a button that drops down a grid
  enum { ROLE_BUTTONDROPDOWNGRID = 66U }; // ATK_ROLE_UNKNOWN
  enum { ROLE_WHITESPACE = 66U };  // ATK_ROLE_UNKNOWN
  enum { ROLE_PAGETABLIST = 37U }; // ATK_ROLE_PAGE_TAB_LIST
  enum { ROLE_CLOCK = 66U };       // ATK_ROLE_UNKNOWN
  // Represents a button on the toolbar that has a drop-down list icon
  // directly adjacent to the button
  enum { ROLE_SPLITBUTTON = 42U }; // ATK_ROLE_PUSH_BUTTON
  enum { ROLE_IPADDRESS = 66U };   // ATK_ROLE_UNKNOWN
  enum { ROLE_NOTHING = 66U };     // ATK_ROLE_UNKNOWN
  // Represent top level window
  enum { ROLE_FRAME = 22U };               // ATK_ROLE_FRAME
  // Other roles from atk.h
  enum { ROLE_ACCEL_LABEL = 1U };          // ATK_ROLE_ACCEL_LABEL
  enum { ROLE_ARROW  = 4U };               // ATK_ROLE_ARROW
  enum { ROLE_CANVAS = 6U };               // ATK_ROLE_CANVAS
  enum { ROLE_CHECK_MENU_ITEM = 8U };      // ATK_ROLE_CHECK_MENU_ITEM
  enum { ROLE_COLOR_CHOOSER  = 9U };       // ATK_ROLE_COLOR_CHOOSER
  enum { ROLE_DATE_EDITOR = 12U };         // ATK_ROLE_DATE_EDITOR
  enum { ROLE_DESKTOP_ICON = 13U };        // ATK_ROLE_DESKTOP_ICON
  enum { ROLE_DESKTOP_FRAME = 14U };       // ATK_ROLE_DESKTOP_FRAME
  enum { ROLE_DIRECTORY_PANE = 17U };      // ATK_ROLE_DIRECTORY_PANE
  enum { ROLE_FILE_CHOOSER = 19U};         // ATK_ROLE_FILE_CHOOSER
  enum { ROLE_FILLER = 20U };              // ATK_ROLE_FILLER
  enum { ROLE_FONT_CHOOSER = 21U };        // ATK_ROLE_FONT_CHOOSER
  enum { ROLE_GLASS_PANE = 23U };          // ATK_ROLE_GLASS_PANE
  enum { ROLE_HTML_CONTAINER = 24U };      // ATK_ROLE_HTML_CONTAINER
  enum { ROLE_ICON = 25U };                // ATK_ROLE_ICON
  enum { ROLE_INTERNAL_FRAME = 27U };      // ATK_ROLE_INTERNAL_FRAME
  enum { ROLE_LABEL = 28U };               // ATK_ROLE_LABEL
  enum { ROLE_LAYERED_PANE = 29U };        // ATK_ROLE_LAYERED_PANE
  enum { ROLE_OPTION_PANE = 35U };         // ATK_ROLE_OPTION_PANE
  enum { ROLE_PASSWORD_TEXT = 39U };       // ATK_ROLE_PASSWORD_TEXT
  enum { ROLE_POPUP_MENU = 40U };          // ATK_ROLE_POPUP_MENU
  enum { ROLE_RADIO_MENU_ITEM = 44U };     // ATK_ROLE_RADIO_MENU_ITEM
  enum { ROLE_ROOT_PANE = 45U };           // ATK_ROLE_ROOT_PANE
  enum { ROLE_SCROLL_PANE = 48U };         // ATK_ROLE_SCROLL_PANE
  enum { ROLE_SPLIT_PANE = 51U };          // ATK_ROLE_SPLIT_PANE
  enum { ROLE_TABLE_COLUMN_HEADER = 56U }; // ATK_ROLE_TABLE_COLUMN_HEADER
  enum { ROLE_TABLE_ROW_HEADER = 57U };    // ATK_ROLE_TABLE_ROW_HEADER
  enum { ROLE_TEAR_OFF_MENU_ITEM = 58U };  // ATK_ROLE_TEAR_OFF_MENU_ITEM
  enum { ROLE_TERMINAL = 59U };            // ATK_ROLE_TERMINAL
  enum { ROLE_TOGGLE_BUTTON = 61U };       // ATK_ROLE_TOGGLE_BUTTON
  enum { ROLE_TREE_TABLE = 65U };          // ATK_ROLE_TREE_TABLE
  enum { ROLE_VIEWPORT = 67U };            // ATK_ROLE_VIEWPORT
  enum { ROLE_HEADER = 69U };              // ATK_ROLE_HEADER
  enum { ROLE_FOOTER = 70U };              // ATK_ROLE_FOOTER
  enum { ROLE_PARAGRAPH = 71U };           // ATK_ROLE_PARAGRAPH
  enum { ROLE_RULER = 72U };               // ATK_ROLE_RULER
  enum { ROLE_AUTOCOMPLETE = 74U };        // ATK_ROLE_AUTOCOMPLETE
  enum { ROLE_EDITBAR = 75U };             // ATK_ROLE_EDITBAR
  enum { ROLE_EMBEDDED = 76U };            // ATK_ROLE_EMBEDDED
  enum { ROLE_ENTRY = 77U };               // ATK_ROLE_ENTRY
  enum { ROLE_CAPTION = 79U };             // ATK_ROLE_CAPTION
  enum { ROLE_DOCUMENT_FRAME = 80U };      // ATK_ROLE_DOCUMENT_FRAME
  enum { ROLE_HEADING = 81U };             // ATK_ROLE_HEADING
  enum { ROLE_PAGE = 82U };                // ATK_ROLE_PAGE
  enum { ROLE_SECTION = 83U };             // ATK_ROLE_SECTION
  enum { ROLE_REDUNDANT_OBJECT = 84U };    // ATK_ROLE_REDUNDANT_OBJECT
#else
// MSAA Roles - only one per nsIAccessible or IAccessible
  enum { ROLE_TITLEBAR = 1U };
  enum { ROLE_MENUBAR = 2U };
  enum { ROLE_SCROLLBAR = 3U };
  enum { ROLE_GRIP = 4U };
  enum { ROLE_SOUND = 5U };
  enum { ROLE_CURSOR = 6U };
  enum { ROLE_CARET = 7U };
  enum { ROLE_ALERT = 8U };
  enum { ROLE_WINDOW = 9U };
  enum { ROLE_CLIENT = 10U };
  enum { ROLE_MENUPOPUP = 11U };
  enum { ROLE_MENUITEM = 12U };
  enum { ROLE_RADIO_MENU_ITEM = 12U }; // Same as ROLE_MENUITEM
  enum { ROLE_CHECK_MENU_ITEM = 12U }; // Same as ROLE_MENUITEM
  enum { ROLE_TOOLTIP = 13U };
  enum { ROLE_APPLICATION = 14U };
  enum { ROLE_DOCUMENT = 15U };
  enum { ROLE_PANE = 16U };
  enum { ROLE_CHART = 17U };
  enum { ROLE_DIALOG = 18U };
  enum { ROLE_BORDER = 19U };
  enum { ROLE_GROUPING = 20U };
  enum { ROLE_SEPARATOR = 21U };
  enum { ROLE_TOOLBAR = 22U };
  enum { ROLE_STATUSBAR = 23U };
  enum { ROLE_TABLE = 24U };
  enum { ROLE_COLUMNHEADER = 25U };
  enum { ROLE_ROWHEADER = 26U };
  enum { ROLE_COLUMN = 27U };
  enum { ROLE_ROW = 28U };
  enum { ROLE_CELL = 29U };
  enum { ROLE_LINK = 30U };
  enum { ROLE_HELPBALLOON = 31U };
  enum { ROLE_CHARACTER = 32U };
  enum { ROLE_LIST = 33U };
  enum { ROLE_LISTITEM = 34U };
  enum { ROLE_OUTLINE = 35U };
  enum { ROLE_TREE_TABLE = 35U }; // Same as ROLE_OUTLINE
  enum { ROLE_OUTLINEITEM = 36U };
  enum { ROLE_PAGETAB = 37U };
  enum { ROLE_PROPERTYPAGE = 38U };
  enum { ROLE_INDICATOR = 39U };
  enum { ROLE_GRAPHIC = 40U };
  enum { ROLE_STATICTEXT = 41U };
  enum { ROLE_TEXT = 42U };
  enum { ROLE_PUSHBUTTON = 43U };
  enum { ROLE_CHECKBUTTON = 44U };
  enum { ROLE_RADIOBUTTON = 45U };
  enum { ROLE_COMBOBOX = 46U };
  enum { ROLE_DROPLIST = 47U };
  enum { ROLE_PROGRESSBAR = 48U };
  enum { ROLE_DIAL = 49U };
  enum { ROLE_HOTKEYFIELD = 50U };
  enum { ROLE_SLIDER = 51U };
  enum { ROLE_SPINBUTTON = 52U };
  enum { ROLE_DIAGRAM = 53U };
  enum { ROLE_ANIMATION = 54U };
  enum { ROLE_EQUATION = 55U };
  enum { ROLE_BUTTONDROPDOWN = 56U };
  enum { ROLE_BUTTONMENU = 57U };
  enum { ROLE_BUTTONDROPDOWNGRID = 58U };
  enum { ROLE_WHITESPACE = 59U };
  enum { ROLE_PAGETABLIST = 60U };
  enum { ROLE_CLOCK = 61U };
  enum { ROLE_SPLITBUTTON = 62U };
  enum { ROLE_IPADDRESS = 63U };
  enum { ROLE_NOTHING = 4294967295U };
// Make up for ATK roles that we don't have in MSAA
// When in doubt map them to ROLE_NOTHING so that the role string is exposed
  enum { ROLE_ICON = ROLE_NOTHING };
  enum { ROLE_PASSWORD_TEXT = ROLE_TEXT };
  enum { ROLE_AUTOCOMPLETE = ROLE_COMBOBOX };
  enum { ROLE_EDITBAR = ROLE_NOTHING };
  enum { ROLE_EMBEDDED = ROLE_NOTHING };
  enum { ROLE_ENTRY = ROLE_NOTHING };
  enum { ROLE_CAPTION = ROLE_NOTHING };
  enum { ROLE_DOCUMENT_FRAME = ROLE_NOTHING };
  enum { ROLE_HEADING = ROLE_NOTHING };
  enum { ROLE_PAGE = ROLE_NOTHING };
  enum { ROLE_SECTION = ROLE_NOTHING };
  enum { ROLE_REDUNDANT_OBJECT = ROLE_NOTHING };
// MSAA relationship extensions to accNavigate
  enum { NAVRELATION_CONTROLLED_BY = 0x1000 };
  enum { NAVRELATION_CONTROLLER_FOR = 0x1001 };
  enum { NAVRELATION_LABEL_FOR = 0x1002 };
  enum { NAVRELATION_LABELLED_BY = 0x1003 };
  enum { NAVRELATION_MEMBER_OF = 0x1004 };
  enum { NAVRELATION_NODE_CHILD_OF = 0x1005 };
  enum { NAVRELATION_FLOWS_TO = 0x1006 };
  enum { NAVRELATION_FLOWS_FROM = 0x1007 };
  enum { NAVRELATION_SUBWINDOW_OF = 0x1008 };
  enum { NAVRELATION_EMBEDS = 0x1009 };
  enum { NAVRELATION_EMBEDDED_BY = 0x100a };
  enum { NAVRELATION_POPUP_FOR = 0x100b };
  enum { NAVRELATION_PARENT_WINDOW_OF = 0x100c };
  enum { NAVRELATION_DEFAULT_BUTTON = 0x100d };
  enum { NAVRELATION_DESCRIBED_BY = 0x100e };
  enum { NAVRELATION_DESCRIPTION_FOR = 0x100f };
#endif
};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIACCESSIBLE \
  NS_IMETHOD GetParent(nsIAccessible * *aParent); \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling); \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling); \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild); \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild); \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount); \
  NS_IMETHOD GetIndexInParent(PRInt32 *aIndexInParent); \
  NS_IMETHOD GetName(nsAString & aName); \
  NS_IMETHOD SetName(const nsAString & aName); \
  NS_IMETHOD GetFinalValue(nsAString & aFinalValue); \
  NS_IMETHOD GetDescription(nsAString & aDescription); \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut); \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding); \
  NS_IMETHOD GetRole(PRUint32 *aRole); \
  NS_IMETHOD GetFinalRole(PRUint32 *aFinalRole); \
  NS_IMETHOD GetFinalState(PRUint32 *aFinalState); \
  NS_IMETHOD GetExtState(PRUint32 *aExtState); \
  NS_IMETHOD GetHelp(nsAString & aHelp); \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild); \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval); \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval); \
  NS_IMETHOD GetAccessibleRelated(PRUint32 aRelationType, nsIAccessible **_retval); \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height); \
  NS_IMETHOD AddSelection(void); \
  NS_IMETHOD RemoveSelection(void); \
  NS_IMETHOD ExtendSelection(void); \
  NS_IMETHOD TakeSelection(void); \
  NS_IMETHOD TakeFocus(void); \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions); \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval); \
  NS_IMETHOD DoAction(PRUint8 index); \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIACCESSIBLE(_to) \
  NS_IMETHOD GetParent(nsIAccessible * *aParent) { return _to GetParent(aParent); } \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) { return _to GetNextSibling(aNextSibling); } \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) { return _to GetPreviousSibling(aPreviousSibling); } \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) { return _to GetFirstChild(aFirstChild); } \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) { return _to GetLastChild(aLastChild); } \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) { return _to GetChildCount(aChildCount); } \
  NS_IMETHOD GetIndexInParent(PRInt32 *aIndexInParent) { return _to GetIndexInParent(aIndexInParent); } \
  NS_IMETHOD GetName(nsAString & aName) { return _to GetName(aName); } \
  NS_IMETHOD SetName(const nsAString & aName) { return _to SetName(aName); } \
  NS_IMETHOD GetFinalValue(nsAString & aFinalValue) { return _to GetFinalValue(aFinalValue); } \
  NS_IMETHOD GetDescription(nsAString & aDescription) { return _to GetDescription(aDescription); } \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) { return _to GetKeyboardShortcut(aKeyboardShortcut); } \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) { return _to GetKeyBinding(aKeyBinding); } \
  NS_IMETHOD GetRole(PRUint32 *aRole) { return _to GetRole(aRole); } \
  NS_IMETHOD GetFinalRole(PRUint32 *aFinalRole) { return _to GetFinalRole(aFinalRole); } \
  NS_IMETHOD GetFinalState(PRUint32 *aFinalState) { return _to GetFinalState(aFinalState); } \
  NS_IMETHOD GetExtState(PRUint32 *aExtState) { return _to GetExtState(aExtState); } \
  NS_IMETHOD GetHelp(nsAString & aHelp) { return _to GetHelp(aHelp); } \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) { return _to GetFocusedChild(aFocusedChild); } \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) { return _to GetChildAtPoint(x, y, _retval); } \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) { return _to GetChildAt(aChildIndex, _retval); } \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) { return _to GetAccessibleToRight(_retval); } \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) { return _to GetAccessibleToLeft(_retval); } \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) { return _to GetAccessibleAbove(_retval); } \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) { return _to GetAccessibleBelow(_retval); } \
  NS_IMETHOD GetAccessibleRelated(PRUint32 aRelationType, nsIAccessible **_retval) { return _to GetAccessibleRelated(aRelationType, _retval); } \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return _to GetBounds(x, y, width, height); } \
  NS_IMETHOD AddSelection(void) { return _to AddSelection(); } \
  NS_IMETHOD RemoveSelection(void) { return _to RemoveSelection(); } \
  NS_IMETHOD ExtendSelection(void) { return _to ExtendSelection(); } \
  NS_IMETHOD TakeSelection(void) { return _to TakeSelection(); } \
  NS_IMETHOD TakeFocus(void) { return _to TakeFocus(); } \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) { return _to GetNumActions(aNumActions); } \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) { return _to GetActionName(index, _retval); } \
  NS_IMETHOD DoAction(PRUint8 index) { return _to DoAction(index); } \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) { return _to GetNativeInterface(aOutAccessible); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIACCESSIBLE(_to) \
  NS_IMETHOD GetParent(nsIAccessible * *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_IMETHOD GetNextSibling(nsIAccessible * *aNextSibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNextSibling(aNextSibling); } \
  NS_IMETHOD GetPreviousSibling(nsIAccessible * *aPreviousSibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPreviousSibling(aPreviousSibling); } \
  NS_IMETHOD GetFirstChild(nsIAccessible * *aFirstChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstChild(aFirstChild); } \
  NS_IMETHOD GetLastChild(nsIAccessible * *aLastChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastChild(aLastChild); } \
  NS_IMETHOD GetChildCount(PRInt32 *aChildCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildCount(aChildCount); } \
  NS_IMETHOD GetIndexInParent(PRInt32 *aIndexInParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIndexInParent(aIndexInParent); } \
  NS_IMETHOD GetName(nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD SetName(const nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(aName); } \
  NS_IMETHOD GetFinalValue(nsAString & aFinalValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFinalValue(aFinalValue); } \
  NS_IMETHOD GetDescription(nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_IMETHOD GetKeyboardShortcut(nsAString & aKeyboardShortcut) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyboardShortcut(aKeyboardShortcut); } \
  NS_IMETHOD GetKeyBinding(nsAString & aKeyBinding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyBinding(aKeyBinding); } \
  NS_IMETHOD GetRole(PRUint32 *aRole) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRole(aRole); } \
  NS_IMETHOD GetFinalRole(PRUint32 *aFinalRole) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFinalRole(aFinalRole); } \
  NS_IMETHOD GetFinalState(PRUint32 *aFinalState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFinalState(aFinalState); } \
  NS_IMETHOD GetExtState(PRUint32 *aExtState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExtState(aExtState); } \
  NS_IMETHOD GetHelp(nsAString & aHelp) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHelp(aHelp); } \
  NS_IMETHOD GetFocusedChild(nsIAccessible * *aFocusedChild) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFocusedChild(aFocusedChild); } \
  NS_IMETHOD GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildAtPoint(x, y, _retval); } \
  NS_IMETHOD GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildAt(aChildIndex, _retval); } \
  NS_IMETHOD GetAccessibleToRight(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleToRight(_retval); } \
  NS_IMETHOD GetAccessibleToLeft(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleToLeft(_retval); } \
  NS_IMETHOD GetAccessibleAbove(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleAbove(_retval); } \
  NS_IMETHOD GetAccessibleBelow(nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleBelow(_retval); } \
  NS_IMETHOD GetAccessibleRelated(PRUint32 aRelationType, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleRelated(aRelationType, _retval); } \
  NS_IMETHOD GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBounds(x, y, width, height); } \
  NS_IMETHOD AddSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSelection(); } \
  NS_IMETHOD RemoveSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveSelection(); } \
  NS_IMETHOD ExtendSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtendSelection(); } \
  NS_IMETHOD TakeSelection(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->TakeSelection(); } \
  NS_IMETHOD TakeFocus(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->TakeFocus(); } \
  NS_IMETHOD GetNumActions(PRUint8 *aNumActions) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumActions(aNumActions); } \
  NS_IMETHOD GetActionName(PRUint8 index, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActionName(index, _retval); } \
  NS_IMETHOD DoAction(PRUint8 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoAction(index); } \
  NS_IMETHOD GetNativeInterface(void * *aOutAccessible) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNativeInterface(aOutAccessible); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAccessible : public nsIAccessible
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIACCESSIBLE

  nsAccessible();

private:
  ~nsAccessible();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAccessible, nsIAccessible)

nsAccessible::nsAccessible()
{
  /* member initializers and constructor code */
}

nsAccessible::~nsAccessible()
{
  /* destructor code */
}

/* readonly attribute nsIAccessible parent; */
NS_IMETHODIMP nsAccessible::GetParent(nsIAccessible * *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible nextSibling; */
NS_IMETHODIMP nsAccessible::GetNextSibling(nsIAccessible * *aNextSibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible previousSibling; */
NS_IMETHODIMP nsAccessible::GetPreviousSibling(nsIAccessible * *aPreviousSibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible firstChild; */
NS_IMETHODIMP nsAccessible::GetFirstChild(nsIAccessible * *aFirstChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible lastChild; */
NS_IMETHODIMP nsAccessible::GetLastChild(nsIAccessible * *aLastChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long childCount; */
NS_IMETHODIMP nsAccessible::GetChildCount(PRInt32 *aChildCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long indexInParent; */
NS_IMETHODIMP nsAccessible::GetIndexInParent(PRInt32 *aIndexInParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString name; */
NS_IMETHODIMP nsAccessible::GetName(nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAccessible::SetName(const nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString finalValue; */
NS_IMETHODIMP nsAccessible::GetFinalValue(nsAString & aFinalValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString description; */
NS_IMETHODIMP nsAccessible::GetDescription(nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString keyboardShortcut; */
NS_IMETHODIMP nsAccessible::GetKeyboardShortcut(nsAString & aKeyboardShortcut)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString keyBinding; */
NS_IMETHODIMP nsAccessible::GetKeyBinding(nsAString & aKeyBinding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long role; */
NS_IMETHODIMP nsAccessible::GetRole(PRUint32 *aRole)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long finalRole; */
NS_IMETHODIMP nsAccessible::GetFinalRole(PRUint32 *aFinalRole)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long finalState; */
NS_IMETHODIMP nsAccessible::GetFinalState(PRUint32 *aFinalState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long extState; */
NS_IMETHODIMP nsAccessible::GetExtState(PRUint32 *aExtState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString help; */
NS_IMETHODIMP nsAccessible::GetHelp(nsAString & aHelp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible focusedChild; */
NS_IMETHODIMP nsAccessible::GetFocusedChild(nsIAccessible * *aFocusedChild)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getChildAtPoint (in long x, in long y); */
NS_IMETHODIMP nsAccessible::GetChildAtPoint(PRInt32 x, PRInt32 y, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getChildAt (in long aChildIndex); */
NS_IMETHODIMP nsAccessible::GetChildAt(PRInt32 aChildIndex, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleToRight (); */
NS_IMETHODIMP nsAccessible::GetAccessibleToRight(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleToLeft (); */
NS_IMETHODIMP nsAccessible::GetAccessibleToLeft(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleAbove (); */
NS_IMETHODIMP nsAccessible::GetAccessibleAbove(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleBelow (); */
NS_IMETHODIMP nsAccessible::GetAccessibleBelow(nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleRelated (in unsigned long aRelationType); */
NS_IMETHODIMP nsAccessible::GetAccessibleRelated(PRUint32 aRelationType, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getBounds (out long x, out long y, out long width, out long height); */
NS_IMETHODIMP nsAccessible::GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addSelection (); */
NS_IMETHODIMP nsAccessible::AddSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeSelection (); */
NS_IMETHODIMP nsAccessible::RemoveSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void extendSelection (); */
NS_IMETHODIMP nsAccessible::ExtendSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void takeSelection (); */
NS_IMETHODIMP nsAccessible::TakeSelection()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void takeFocus (); */
NS_IMETHODIMP nsAccessible::TakeFocus()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRUint8 numActions; */
NS_IMETHODIMP nsAccessible::GetNumActions(PRUint8 *aNumActions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getActionName (in PRUint8 index); */
NS_IMETHODIMP nsAccessible::GetActionName(PRUint8 index, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doAction (in PRUint8 index); */
NS_IMETHODIMP nsAccessible::DoAction(PRUint8 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void getNativeInterface (out voidPtr aOutAccessible); */
NS_IMETHODIMP nsAccessible::GetNativeInterface(void * *aOutAccessible)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAccessible_h__ */
