% STRCMP STRCMP String Compare Function
% 
% Usage
% 
% Compares two strings for equality.  The general
% syntax for its use is
% 
%   p = strcmp(x,y)
% 
% where x and y are two strings.  Returns true if x
% and y are the same size, and are equal (as strings).  Otherwise,
% it returns false.
% In the second form, strcmp can be applied to a cell array of
% strings.  The syntax for this form is
% 
%   p = strcmp(cellstra,cellstrb)
% 
% where cellstra and cellstrb are cell arrays of a strings
% to compare.  Also, you can also supply a character matrix as
% an argument to strcmp, in which case it will be converted
% via cellstr (so that trailing spaces are removed), before being
% compared.


% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = strcmp(source,pattern)
  if (isstr(source) & isstr(pattern))
    y = strcmp_string_string(source,pattern);
  else
    y = strcmp_cell_cell(cellstr(source),cellstr(pattern));
  end


function y = strcmp_string_string(source,pattern)
  y = strcomp(source,pattern);

function y = strcmp_cell_cell(source,pattern)
  if (isscalar(source))
    source = repmat(source,size(pattern));
  end
  if (isscalar(pattern))
    pattern = repmat(pattern,size(source));
  end
  if (numel(source) ~= numel(pattern))
    error('cell array arguments must be the same size')
  end
  y = logical(zeros(size(source)));
  for (i=1:numel(source))
    y(i) = strcomp(source{i},pattern{i});
  end
