/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathImpl
implements IClassPath {
    private List<IScannableCodeBase> appCodeBaseList = new LinkedList<IScannableCodeBase>();
    private List<ICodeBase> auxCodeBaseList = new LinkedList<ICodeBase>();
    private Map<String, ICodeBaseEntry> codeBaseEntryMap = new HashMap<String, ICodeBaseEntry>();

    @Override
    public void addCodeBase(ICodeBase codeBase) {
        if (codeBase.isApplicationCodeBase()) {
            if (!(codeBase instanceof IScannableCodeBase)) {
                throw new IllegalStateException();
            }
            this.appCodeBaseList.add((IScannableCodeBase)codeBase);
        } else {
            this.auxCodeBaseList.add(codeBase);
        }
    }

    @Override
    public Iterator<? extends ICodeBase> appCodeBaseIterator() {
        return this.appCodeBaseList.iterator();
    }

    @Override
    public Iterator<? extends ICodeBase> auxCodeBaseIterator() {
        return this.auxCodeBaseList.iterator();
    }

    @Override
    public void close() {
        for (IScannableCodeBase iScannableCodeBase : this.appCodeBaseList) {
            iScannableCodeBase.close();
        }
        for (ICodeBase iCodeBase : this.auxCodeBaseList) {
            iCodeBase.close();
        }
    }

    @Override
    public ICodeBaseEntry lookupResource(String resourceName) throws ResourceNotFoundException {
        ICodeBaseEntry result = this.codeBaseEntryMap.get(resourceName);
        if (result == null) {
            result = this.search(this.appCodeBaseList, resourceName);
            if (result == null) {
                result = this.search(this.auxCodeBaseList, resourceName);
            }
            if (result == null) {
                throw new ResourceNotFoundException(resourceName);
            }
            this.codeBaseEntryMap.put(resourceName, result);
        }
        return result;
    }

    private ICodeBaseEntry search(List<? extends ICodeBase> codeBaseList, String resourceName) {
        for (ICodeBase iCodeBase : codeBaseList) {
            try {
                return iCodeBase.lookupResource(resourceName);
            }
            catch (ResourceNotFoundException e) {
            }
        }
        return null;
    }

    @Override
    public void mapResourceNameToCodeBaseEntry(String resourceName, ICodeBaseEntry codeBaseEntry) {
        this.codeBaseEntryMap.put(resourceName, codeBaseEntry);
    }
}

