/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.IColorManagerExtension;

public abstract class AbstractRubyScanner
extends BufferedRuleBasedScanner {
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private String[] fPropertyNamesStrikethrough;
    private String[] fPropertyNamesUnderline;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private boolean fNeedsLazyColorLoading;
    private Map fTokenMap = new HashMap();

    public AbstractRubyScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    private void initializeRules() {
        List list = this.createRules();
        if (list != null) {
            IRule[] iRuleArray = new IRule[list.size()];
            list.toArray(iRuleArray);
            this.setRules(iRuleArray);
        }
    }

    public IToken nextToken() {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return super.nextToken();
    }

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int n = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[n];
        this.fPropertyNamesItalic = new String[n];
        this.fPropertyNamesStrikethrough = new String[n];
        this.fPropertyNamesUnderline = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.fPropertyNamesBold[n2] = this.getBoldKey(this.fPropertyNamesColor[n2]);
            this.fPropertyNamesItalic[n2] = this.getItalicKey(this.fPropertyNamesColor[n2]);
            this.fPropertyNamesStrikethrough[n2] = this.getStrikethroughKey(this.fPropertyNamesColor[n2]);
            this.fPropertyNamesUnderline[n2] = this.getUnderlineKey(this.fPropertyNamesColor[n2]);
            ++n2;
        }
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        n2 = 0;
        while (n2 < n) {
            if (this.fNeedsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.fPropertyNamesColor[n2], this.fPropertyNamesBold[n2], this.fPropertyNamesItalic[n2], this.fPropertyNamesStrikethrough[n2], this.fPropertyNamesUnderline[n2]);
            } else {
                this.addToken(this.fPropertyNamesColor[n2], this.fPropertyNamesBold[n2], this.fPropertyNamesItalic[n2], this.fPropertyNamesStrikethrough[n2], this.fPropertyNamesUnderline[n2]);
            }
            ++n2;
        }
        this.initializeRules();
    }

    protected String getBoldKey(String string) {
        return String.valueOf(string) + "_bold";
    }

    protected String getItalicKey(String string) {
        return String.valueOf(string) + "_italic";
    }

    protected String getStrikethroughKey(String string) {
        return String.valueOf(string) + "_strikethrough";
    }

    protected String getUnderlineKey(String string) {
        return String.valueOf(string) + "_underline";
    }

    private void addTokenWithProxyAttribute(String string, String string2, String string3, String string4, String string5) {
        this.fTokenMap.put(string, new Token((Object)this.createTextAttribute(null, string2, string3, string4, string5)));
    }

    private void resolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            int n = 0;
            while (n < this.fPropertyNamesColor.length) {
                this.addToken(this.fPropertyNamesColor[n], this.fPropertyNamesBold[n], this.fPropertyNamesItalic[n], this.fPropertyNamesStrikethrough[n], this.fPropertyNamesUnderline[n]);
                ++n;
            }
            this.fNeedsLazyColorLoading = false;
        }
    }

    private void addToken(String string, String string2, String string3, String string4, String string5) {
        Token token;
        if (this.fColorManager != null && string != null && this.fColorManager.getColor(string) == null) {
            token = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension iColorManagerExtension = (IColorManagerExtension)((Object)this.fColorManager);
                iColorManagerExtension.unbindColor(string);
                iColorManagerExtension.bindColor(string, (RGB)token);
            }
        }
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(string, new Token((Object)this.createTextAttribute(string, string2, string3, string4, string5)));
        } else {
            token = (Token)this.fTokenMap.get(string);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(string, string2, string3, string4, string5));
            }
        }
    }

    protected Token getToken(String string) {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return (Token)this.fTokenMap.get(string);
    }

    private TextAttribute createTextAttribute(String string, String string2, String string3, String string4, String string5) {
        int n;
        Color color = null;
        if (string != null) {
            color = this.fColorManager.getColor(string);
        }
        int n2 = n = this.fPreferenceStore.getBoolean(string2) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(string3)) {
            n |= 2;
        }
        if (this.fPreferenceStore.getBoolean(string4)) {
            n |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(string5)) {
            n |= 0x40000000;
        }
        return new TextAttribute(color, null, n);
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.indexOf(propertyChangeEvent.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        int n = this.indexOf(string);
        Token token = this.getToken(this.fPropertyNamesColor[n]);
        if (this.fPropertyNamesColor[n].equals(string)) {
            this.adaptToColorChange(token, propertyChangeEvent);
        } else if (this.fPropertyNamesBold[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 1);
        } else if (this.fPropertyNamesItalic[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 2);
        } else if (this.fPropertyNamesStrikethrough[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 0x20000000);
        } else if (this.fPropertyNamesUnderline[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 0x40000000);
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent, int n) {
        boolean bl = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if ("true".equals(object)) {
            bl = true;
        }
        Object object2 = token.getData();
        if (object2 instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object2;
            boolean bl3 = bl2 = (textAttribute.getStyle() & n) == n;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n));
            }
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            Object object2;
            String string = propertyChangeEvent.getProperty();
            Color color = this.fColorManager.getColor(string);
            if ((color == null || !rGB.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                object2 = (IColorManagerExtension)((Object)this.fColorManager);
                object2.unbindColor(string);
                object2.bindColor(string, rGB);
                color = this.fColorManager.getColor(string);
            }
            if ((object2 = token.getData()) instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(color, textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private int indexOf(String string) {
        if (string != null) {
            int n = this.fPropertyNamesColor.length;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(this.fPropertyNamesColor[n2]) || string.equals(this.fPropertyNamesBold[n2]) || string.equals(this.fPropertyNamesItalic[n2]) || string.equals(this.fPropertyNamesStrikethrough[n2]) || string.equals(this.fPropertyNamesUnderline[n2])) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }
}

