/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusUtil;

public class ResourceWithStatusLabelProvider
extends WorkbenchLabelProvider
implements ITableLabelProvider {
    private final String baseUrl;

    ResourceWithStatusLabelProvider(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        switch (columnIndex) {
            case 0: {
                result = "";
                break;
            }
            case 1: {
                result = this.baseUrl == null ? ((IResource)element).getFullPath().toString() : this.getResource((IResource)element);
                if (result.length() != 0) break;
                result = ((IResource)element).getFullPath().toString();
                break;
            }
            case 2: {
                result = ResourceWithStatusUtil.getStatus((IResource)element);
                break;
            }
            case 3: {
                result = ResourceWithStatusUtil.getPropertyStatus((IResource)element);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private String getResource(IResource resource) {
        String[] segments = resource.getFullPath().segments();
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < segments.length) {
            path.append("/" + segments[i]);
            if (this.baseUrl.endsWith(path.toString())) {
                if (i == segments.length - 2) {
                    return resource.getFullPath().toString().substring(path.length() + 1);
                }
                return resource.getFullPath().toString().substring(path.length());
            }
            ++i;
        }
        return resource.getFullPath().toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 1) {
            return this.getImage(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

