/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public abstract class J2EEComponentSaveStrategyImpl
extends ComponentSaveStrategyImpl {
    protected final String DOT_CLASS = ".class";
    protected final String IMPORTED_CLASSES = "ImportedClasses";
    protected boolean importedClassesFolderCreated = false;
    protected IFolder importedClassesFolder;

    public J2EEComponentSaveStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    protected void saveFiles() throws SaveFailureException {
        super.saveFiles();
        this.linkImportedClassesFolderIfNecessary();
        try {
            this.vComponent.getProject().refreshLocal(2, null);
        }
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    public boolean endsWithClassType(String aFileName) {
        return aFileName.endsWith(".class");
    }

    protected boolean shouldSave(File aFile) {
        if (this.endsWithClassType(aFile.getURI())) {
            boolean shouldSave = this.isClassWithoutSource(aFile);
            if (shouldSave && !this.importedClassesFolderCreated) {
                this.createImportedClassesFolder();
            }
            return shouldSave;
        }
        return super.shouldSave(aFile);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualFile vFile = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile iFile = vFile.getUnderlyingFile();
        this.validateEdit(iFile);
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(iFile);
        try {
            try {
                aManifest.write((OutputStream)out);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
            return;
        }
        out.close();
    }

    protected void createImportedClassesFolder() {
        this.importedClassesFolderCreated = true;
        IContainer jarParent = this.vComponent.getRootFolder().getUnderlyingFolder().getParent();
        this.importedClassesFolder = jarParent.getFolder((IPath)new Path("ImportedClasses"));
        try {
            this.importedClassesFolder.create(true, true, null);
        }
        catch (CoreException e1) {
            Logger.getLogger().logError((Throwable)e1);
        }
    }

    protected void linkImportedClassesFolderIfNecessary() {
        if (this.importedClassesFolder != null) {
            try {
                this.vComponent.getRootFolder().getFolder(this.getImportedClassesRuntimePath()).createLink(this.importedClassesFolder.getProjectRelativePath(), 0, null);
                if (this.shouldAddImportedClassesToClasspath() && JemProjectUtilities.getJavaProject((IProject)this.vComponent.getProject()) != null) {
                    IJavaProject javaProject = JavaCore.create((IProject)this.vComponent.getProject());
                    IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
                    IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + 1];
                    System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                    newJavaClasspath[newJavaClasspath.length - 1] = JavaCore.newLibraryEntry((IPath)this.importedClassesFolder.getFullPath(), null, null, (boolean)true);
                    javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    protected boolean shouldAddImportedClassesToClasspath() {
        return true;
    }

    protected IPath getImportedClassesRuntimePath() {
        return new Path("/");
    }

    protected IPath getOutputPathForFile(File aFile) {
        if (this.endsWithClassType(aFile.getURI())) {
            return this.importedClassesFolder.getFile(this.getImportedClassesURI(aFile)).getProjectRelativePath();
        }
        return super.getOutputPathForFile(aFile);
    }

    protected String getImportedClassesURI(File aFile) {
        return aFile.getURI();
    }

    protected boolean isClassWithoutSource(File aFile) {
        String javaUri = ArchiveUtil.classUriToJavaUri((String)aFile.getURI());
        if (javaUri == null) {
            return false;
        }
        return !this.archive.containsFile(javaUri);
    }
}

