/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.views.contentoutline;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.DragNodeCommand;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ActionManagerMenuListener fContextMenuFiller = null;
    private ILabelProvider fLabelProvider = null;
    boolean fShowAttributes = false;
    private TransferDragSourceListener[] fTransferDragSourceListeners;
    private TransferDropTargetListener[] fTransferDropTargetListeners;
    private final String OUTLINE_SHOW_ATTRIBUTE_PREF = "outline-show-attribute-editor";

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem showAttributeItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleShowAttributeAction(this.getPreferenceStore(), "outline-show-attribute-editor", viewer));
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showAttributeItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showAttributeItem;
            items = combinedItems;
        }
        return items;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new XMLNodeActionManager((IStructuredModel)treeViewer.getInput(), (Viewer)treeViewer);
    }

    protected void enableShowAttributes(boolean showAttributes, TreeViewer treeViewer) {
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JFaceNodeContentProvider();
        }
        return this.fContentProvider;
    }

    private Object getFilteredNode(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            if (node.getNodeType() == 2) {
                node = ((Attr)node).getOwnerElement();
            } else if (node.getNodeType() == 3) {
                node = node.getParentNode();
            }
            return node;
        }
        return object;
    }

    private Object[] getFilteredNodes(Object[] filteredNodes) {
        int i = 0;
        while (i < filteredNodes.length) {
            filteredNodes[i] = this.getFilteredNode(filteredNodes[i]);
            ++i;
        }
        return filteredNodes;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new AttributeShowingLabelProvider();
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fContextMenuFiller == null) {
            this.fContextMenuFiller = new ActionManagerMenuListener(viewer);
        }
        return this.fContextMenuFiller;
    }

    protected IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection filteredSelection = selection;
        if (selection instanceof IStructuredSelection) {
            Object[] filteredNodes = this.getFilteredNodes(((IStructuredSelection)selection).toArray());
            filteredSelection = new StructuredSelection(filteredNodes);
        }
        return filteredSelection;
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(final TreeViewer treeViewer) {
        if (this.fTransferDragSourceListeners == null) {
            this.fTransferDragSourceListeners = new TransferDragSourceListener[]{new TransferDragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }

                public void dragSetData(DragSourceEvent event) {
                }

                public void dragStart(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(treeViewer.getSelection());
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }
            }};
        }
        return this.fTransferDragSourceListeners;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(final TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            this.fTransferDropTargetListeners = new TransferDropTargetListener[]{new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                }

                public void dragLeave(DropTargetEvent event) {
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 1;
                    float feedbackFloat = this.getHeightInItem(event);
                    if ((double)feedbackFloat > 0.75) {
                        event.feedback = 4;
                    } else if ((double)feedbackFloat < 0.25) {
                        event.feedback = 2;
                    }
                    event.feedback |= 0x18;
                }

                public void drop(DropTargetEvent event) {
                    IStructuredSelection selection;
                    if (event.operations != 0 && LocalSelectionTransfer.getTransfer().getSelection() != null && !LocalSelectionTransfer.getTransfer().getSelection().isEmpty() && (selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && event.item != null && event.item.getData() != null) {
                        float feedbackFloat = this.getHeightInItem(event);
                        DragNodeCommand command = new DragNodeCommand(event.item.getData(), feedbackFloat, event.operations, event.detail, selection.toList(), treeViewer);
                        if (command != null && command.canExecute()) {
                            SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, command){
                                final /* synthetic */ 2 this$1;
                                private final /* synthetic */ DragNodeCommand val$command;
                                {
                                    this.this$1 = var1_1;
                                    this.val$command = dragNodeCommand;
                                }

                                public void run() throws Exception {
                                    this.val$command.execute();
                                }
                            });
                        }
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                }

                private float getHeightInItem(DropTargetEvent event) {
                    if (event.item == null) {
                        return 0.5f;
                    }
                    if (event.item instanceof TreeItem) {
                        TreeItem treeItem = (TreeItem)event.item;
                        Tree control = treeItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = treeItem.getBounds();
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    if (event.item instanceof TableItem) {
                        TableItem tableItem = (TableItem)event.item;
                        Table control = tableItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = tableItem.getBounds(0);
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    return 0.0f;
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }

                public boolean isEnabled(DropTargetEvent event) {
                    return this.getTransfer().isSupportedType(event.currentDataType);
                }
            }};
        }
        return this.fTransferDropTargetListeners;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fTransferDragSourceListeners = null;
        this.fTransferDropTargetListeners = null;
        if (this.fContextMenuFiller != null) {
            this.fContextMenuFiller.release();
            this.fContextMenuFiller = null;
        }
    }

    private class ActionManagerMenuListener
    implements IMenuListener,
    IReleasable {
        private XMLNodeActionManager fActionManager;
        private TreeViewer fTreeViewer;

        public ActionManagerMenuListener(TreeViewer viewer) {
            this.fTreeViewer = viewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (this.fActionManager == null) {
                this.fActionManager = XMLContentOutlineConfiguration.this.createNodeActionManager(this.fTreeViewer);
            }
            this.fActionManager.fillContextMenu(manager, this.fTreeViewer.getSelection());
        }

        public void release() {
            this.fTreeViewer = null;
            if (this.fActionManager != null) {
                this.fActionManager.setModel(null);
            }
        }
    }

    private class AttributeShowingLabelProvider
    extends JFaceNodeLabelProvider {
        private AttributeShowingLabelProvider() {
        }

        public String getText(Object o) {
            Node node;
            StringBuffer text = new StringBuffer(super.getText(o));
            if (o instanceof Node && (node = (Node)o).getNodeType() == 1 && XMLContentOutlineConfiguration.this.fShowAttributes && node.hasAttributes()) {
                String attributeName;
                Element element = (Element)node;
                NamedNodeMap attributes = element.getAttributes();
                Node idTypedAttribute = null;
                Node requiredAttribute = null;
                boolean hasId = false;
                boolean hasName = false;
                Node shownAttribute = null;
                CMElementDeclaration elementDecl = null;
                ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
                if (mq != null) {
                    elementDecl = mq.getCMElementDeclaration(element);
                }
                if (elementDecl != null) {
                    int i = 0;
                    while (i < attributes.getLength() && idTypedAttribute == null) {
                        Node attr = attributes.item(i);
                        String attrName = attr.getNodeName();
                        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)elementDecl.getAttributes().getNamedItem(attrName);
                        if (attrDecl != null) {
                            if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                                idTypedAttribute = attr;
                            } else if (attrDecl.getUsage() == 2 && requiredAttribute == null) {
                                requiredAttribute = attr;
                            } else {
                                hasId = hasId || attrName.equals("id");
                                hasName = hasName || attrName.equals("name");
                            }
                        }
                        ++i;
                    }
                }
                if (idTypedAttribute != null) {
                    shownAttribute = idTypedAttribute;
                } else if (requiredAttribute != null) {
                    shownAttribute = requiredAttribute;
                } else if (hasId) {
                    shownAttribute = attributes.getNamedItem("id");
                } else if (hasName) {
                    shownAttribute = attributes.getNamedItem("name");
                }
                if (shownAttribute == null) {
                    shownAttribute = attributes.item(0);
                }
                if ((attributeName = shownAttribute.getNodeName()) != null && attributeName.length() > 0) {
                    text.append(" " + attributeName);
                    String attributeValue = shownAttribute.getNodeValue();
                    if (attributeValue != null && attributeValue.length() > 0) {
                        text.append("=" + StringUtils.strip((String)attributeValue));
                    }
                }
            }
            return text.toString();
        }
    }

    private class ToggleShowAttributeAction
    extends PropertyChangeUpdateAction {
        private TreeViewer fTreeViewer;

        public ToggleShowAttributeAction(IPreferenceStore store, String preference, TreeViewer treeViewer) {
            super(XMLUIMessages.XMLContentOutlineConfiguration_0, store, preference, true);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/prop_ps.gif"));
            this.fTreeViewer = treeViewer;
            this.update();
        }

        public void update() {
            super.update();
            XMLContentOutlineConfiguration.this.fShowAttributes = this.isChecked();
            XMLContentOutlineConfiguration.this.enableShowAttributes(XMLContentOutlineConfiguration.this.fShowAttributes, this.fTreeViewer);
            this.fTreeViewer.refresh(true);
        }
    }
}

