/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.CommonUIPropertiesPlugin;
import org.eclipse.wst.common.ui.properties.internal.l10n.Messages;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITypeMapper;
import org.eclipse.wst.common.ui.properties.internal.view.TabbedPropertyRegistryClassSectionFilter;

public class SectionDescriptor
implements ISectionDescriptor {
    private static final String SECTION_ERROR = Messages.SectionDescriptor_Section_error;
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_TAB = "tab";
    private static final String ATT_AFTER_SECTION = "afterSection";
    private static final String ATT_CLASS = "class";
    private static final String ATT_SECTION_FILTER = "filter";
    private static final String ATT_SECTION_ENABLES_FOR = "enablesFor";
    private static final String ATT_INPUT_TYPE = "type";
    private static final String ELEMENT_INPUT = "input";
    private static final String TOP = "top";
    private String id;
    private String targetTab;
    private String afterSection;
    private ArrayList inputTypes;
    private TabbedPropertyRegistryClassSectionFilter classFilter;
    private ITypeMapper filter;
    private int enablesFor = -1;
    private IConfigurationElement configurationElement;

    protected SectionDescriptor(IConfigurationElement configurationElement, ITypeMapper typeMapper) {
        String enablesForStr;
        int enablesForTest;
        this.configurationElement = configurationElement;
        this.classFilter = new TabbedPropertyRegistryClassSectionFilter(typeMapper);
        this.id = this.getConfigurationElement().getAttribute(ATT_ID);
        this.targetTab = this.getConfigurationElement().getAttribute(ATT_TARGET_TAB);
        this.afterSection = this.getConfigurationElement().getAttribute(ATT_AFTER_SECTION);
        if (this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR) != null && (enablesForTest = Integer.parseInt(enablesForStr = this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR))) > 0) {
            this.enablesFor = enablesForTest;
        }
        if (this.id == null || this.targetTab == null) {
            this.handleSectionError(null);
        }
        if (this.getAfterSection() == null) {
            this.afterSection = TOP;
        }
    }

    private void handleSectionError(CoreException exception) {
        String pluginId = this.getConfigurationElement().getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(SECTION_ERROR, pluginId);
        Status status = new Status(4, pluginId, 6, message, (Throwable)exception);
        CommonUIPropertiesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public String getId() {
        return this.id;
    }

    public ITypeMapper getFilter() {
        if (this.filter == null) {
            try {
                if (this.getConfigurationElement().getAttribute(ATT_SECTION_FILTER) != null) {
                    this.filter = (ITypeMapper)this.configurationElement.createExecutableExtension(ATT_SECTION_FILTER);
                }
            }
            catch (CoreException exception) {
                this.handleSectionError(exception);
            }
        }
        return this.filter;
    }

    public int getEnablesFor() {
        return this.enablesFor;
    }

    public String getTargetTab() {
        return this.targetTab;
    }

    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        return this.classFilter.appliesToSelection(this, selection);
    }

    public String getAfterSection() {
        return this.afterSection;
    }

    public ISection getSectionClass() {
        ISection section = null;
        try {
            section = (ISection)this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException exception) {
            this.handleSectionError(exception);
        }
        return section;
    }

    public List getInputTypes() {
        if (this.inputTypes == null) {
            this.inputTypes = new ArrayList();
            IConfigurationElement[] elements = this.getConfigurationElement().getChildren(ELEMENT_INPUT);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                this.inputTypes.add(element.getAttribute(ATT_INPUT_TYPE));
                ++i;
            }
        }
        return this.inputTypes;
    }

    public String toString() {
        return this.getId();
    }

    private IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }
}

