/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.FileUtil;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;

public abstract class TomcatConfiguration
implements ITomcatConfiguration,
ITomcatConfigurationWorkingCopy {
    public static final String NAME_PROPERTY = "name";
    public static final String PORT_PROPERTY = "port";
    public static final String MODIFY_PORT_PROPERTY = "modifyPort";
    public static final String ADD_MAPPING_PROPERTY = "addMapping";
    public static final String REMOVE_MAPPING_PROPERTY = "removeMapping";
    public static final String MODIFY_MAPPING_PROPERTY = "modifyMapping";
    public static final String MODIFY_WEB_MODULE_PROPERTY = "modifyWebModule";
    public static final String ADD_WEB_MODULE_PROPERTY = "addWebModule";
    public static final String REMOVE_WEB_MODULE_PROPERTY = "removeWebModule";
    public static final String DEFAULT_WEBXML_SERVLET23 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>";
    public static final String DEFAULT_WEBXML_SERVLET24 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>";
    protected IFolder configPath;
    private transient List propertyListeners;
    static /* synthetic */ Class class$0;

    public TomcatConfiguration(IFolder path) {
        this.configPath = path;
    }

    protected IFolder getFolder() {
        return this.configPath;
    }

    protected IStatus backupAndPublish(IPath tomcatDir, boolean doBackup, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.publishConfigurationTask, null);
        Trace.trace(Trace.FINER, "Backup and publish");
        monitor = ProgressUtil.getMonitorFor(monitor);
        try {
            IPath backup = null;
            if (doBackup && !(backup = tomcatDir.append("backup")).toFile().exists()) {
                backup.toFile().mkdir();
            }
            this.backupFolder(this.getFolder(), tomcatDir.append("conf"), backup, ms, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "backupAndPublish() error", e);
            Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            ms.add((IStatus)s);
        }
        monitor.done();
        return ms;
    }

    protected void backupFolder(IFolder folder, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IResource[] children = folder.members();
        if (children == null) {
            return;
        }
        int size = children.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            if (children[i] instanceof IFile) {
                try {
                    IFile file = (IFile)children[i];
                    String name = file.getName();
                    monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                    Trace.trace(Trace.FINEST, "Publishing " + name);
                    boolean copy = true;
                    if (backup != null && !backup.append(name).toFile().exists()) {
                        IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                        ms.add(status);
                        if (!status.isOK()) {
                            copy = false;
                        }
                    }
                    if (copy) {
                        InputStream in = file.getContents();
                        ms.add(FileUtil.copyFile(in, confDir.append(name).toOSString()));
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "backupAndPublish() error", e);
                    ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
                }
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected void backupPath(IPath path, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) {
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return;
        }
        int size = files.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            try {
                File file = files[i];
                String name = file.getName();
                monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                Trace.trace(Trace.FINEST, "Publishing " + name);
                boolean copy = true;
                if (backup != null && !backup.append(name).toFile().exists()) {
                    IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                    ms.add(status);
                    if (!status.isOK()) {
                        copy = false;
                    }
                }
                if (copy) {
                    ms.add(FileUtil.copyFile(file.getAbsolutePath(), confDir.append(name).toOSString()));
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "backupAndPublish() error", e);
                ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected IStatus publishContextConfig(IPath baseDir, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus cleanupServer(IPath confDir, IPath installDir, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus prepareRuntimeDirectory(IPath confDir) {
        File temp = confDir.append("conf").toFile();
        if (!temp.exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public void localizeConfiguration(IPath path, TomcatServer server, IProgressMonitor monitor) {
    }

    public abstract ServerPort getMainPort();

    public String getDocBasePrefix() {
        return "";
    }

    protected String getWebModuleURL(IModule webModule) {
        WebModule module = this.getWebModule(webModule);
        if (module != null) {
            return module.getPath();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWebModule webModule2 = (IWebModule)webModule.loadAdapter((Class)clazz, null);
        return "/" + webModule2.getContextRoot();
    }

    protected WebModule getWebModule(IModule module) {
        if (module == null) {
            return null;
        }
        String memento = module.getId();
        List modules = this.getWebModules();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            WebModule webModule = (WebModule)modules.get(i);
            if (memento.equals(webModule.getMemento())) {
                return webModule;
            }
            ++i;
        }
        return null;
    }

    protected abstract void save(IFolder var1, IProgressMonitor var2) throws CoreException;

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Iterator iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = (PropertyChangeListener)iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error in property event", e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
    }

    protected abstract void load(IPath var1, IProgressMonitor var2) throws CoreException;

    protected abstract void load(IFolder var1, IProgressMonitor var2) throws CoreException;

    public abstract void addWebModule(int var1, ITomcatWebModule var2);

    public abstract void removeWebModule(int var1);

    public String toString() {
        return "TomcatConfiguration[" + this + "]";
    }
}

