/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.xml.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.wst.wsi.internal.core.xml.dom.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    protected DOMParser domParser = null;
    protected EntityResolver entityResolver = null;
    protected ErrorHandler errorHandler = new DefaultHandler();
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    static /* synthetic */ Class class$0;

    public DocumentBuilderImpl(DocumentBuilderFactory dbFactory, Hashtable attributes) throws SAXException {
        this.domParser = new DOMParser();
        this.domParser.setFeature(NAMESPACES_FEATURE, dbFactory.isNamespaceAware());
        this.domParser.setFeature(VALIDATION_FEATURE, dbFactory.isValidating());
        if (dbFactory.isValidating()) {
            this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        this.domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !dbFactory.isIgnoringElementContentWhitespace());
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !dbFactory.isExpandEntityReferences());
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", !dbFactory.isIgnoringComments());
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", !dbFactory.isCoalescing());
        if (attributes != null) {
            Enumeration i = attributes.keys();
            while (i.hasMoreElements()) {
                String attribute = (String)i.nextElement();
                if (attribute.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
                    if (attributes.get(attribute) instanceof InputSource[]) {
                        this.domParser.setProperty(attribute, (InputSource[])attributes.get(attribute));
                        continue;
                    }
                    this.domParser.setProperty(attribute, (InputSource)attributes.get(attribute));
                    continue;
                }
                this.domParser.setProperty(attribute, attributes.get(attribute));
            }
        }
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread thread = Thread.currentThread();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            thread.setContextClassLoader(clazz.getClassLoader());
            if (this.entityResolver != null) {
                this.domParser.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                this.domParser.setErrorHandler(this.errorHandler);
            }
            this.domParser.parse(is);
            Document document = this.domParser.getDocument();
            Object var3_4 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return document;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
    }

    public boolean isNamespaceAware() {
        boolean namespaceAware = false;
        try {
            namespaceAware = this.domParser.getFeature(NAMESPACES_FEATURE);
        }
        catch (SAXException se) {
            throw new RuntimeException(se.toString());
        }
        return namespaceAware;
    }

    public boolean isValidating() {
        boolean validating = false;
        try {
            validating = this.domParser.getFeature(VALIDATION_FEATURE);
        }
        catch (SAXException se) {
            throw new RuntimeException(se.toString());
        }
        return validating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return new DOMImplementationImpl();
    }
}

