/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.decorators;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerStatusDecorationService;

public class ServerStatusDecoration
extends LabelProvider
implements ILightweightLabelDecorator,
IServerStatusDecorationService {
    private static final String PREFIX = " [{0} {1}]";

    public void decorate(Object element, IDecoration decoration) {
        IConnectionNode server = (IConnectionNode)element;
        String type = server.getConnectionInfo().getDatabaseDefinition().getProductDisplayString();
        String version = server.getConnectionInfo().getDatabaseDefinition().getVersionDisplayString();
        if (type != null && version != null && !server.getConnectionInfo().isDiscoverDatabaseDefinitionWhenConnectEnabled()) {
            decoration.addSuffix(MessageFormat.format(PREFIX, type, version));
        }
    }

    public void refreshDecoration(Object[] elements) {
        this.fireLabelChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements));
    }

    protected void fireLabelChangedEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerStatusDecoration.this.fireLabelProviderChanged(event);
            }
        });
    }
}

