/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.team.internal.ccvs.ui.tags.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;

public class ConfigureTagsFromRepoViewOnFolder
extends CVSAction {
    protected ICVSRemoteFolder[] getSelectedRemoteFolders() {
        ArrayList resources = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            resources = new ArrayList();
            for (Object next : selection) {
                if (next instanceof RemoteModule) {
                    next = ((RemoteModule)next).getCVSResource();
                }
                if (!(next instanceof ICVSRemoteFolder)) continue;
                ICVSRemoteFolder folder = (ICVSRemoteFolder)next;
                if (folder.isDefinedModule()) {
                    resources.add(next);
                    continue;
                }
                if (new Path(null, ((ICVSRemoteFolder)next).getRepositoryRelativePath()).segmentCount() != 1) continue;
                resources.add(next);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ICVSRemoteFolder[resources.size()]);
        }
        return new ICVSRemoteFolder[0];
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                final ICVSRemoteFolder[] roots = ConfigureTagsFromRepoViewOnFolder.this.getSelectedRemoteFolders();
                final Shell shell = ConfigureTagsFromRepoViewOnFolder.this.getShell();
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        ICVSFolder[] cvsFolders = new ICVSFolder[roots.length];
                        int i = 0;
                        while (i < roots.length) {
                            cvsFolders[i] = roots[i];
                            ++i;
                        }
                        TagConfigurationDialog d = new TagConfigurationDialog(shell, TagSource.create(cvsFolders));
                        d.open();
                    }
                });
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ICVSRemoteFolder[] roots = this.getSelectedRemoteFolders();
        return roots.length == 1;
    }

    protected String getErrorTitle() {
        return CVSUIMessages.ConfigureTagsFromRepoViewConfigure_Tag_Error_1;
    }
}

