/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class RemoveWorkingSetElementAction
extends SelectionDispatchAction {
    public RemoveWorkingSetElementAction(IWorkbenchSite site) {
        super(site);
        this.setText(WorkingSetMessages.RemoveWorkingSetElementAction_label);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IWorkingSet workingSet = this.getWorkingSet(selection);
        this.setEnabled(workingSet != null && !"org.eclipse.jdt.internal.ui.OthersWorkingSet".equals(workingSet.getId()));
    }

    private IWorkingSet getWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        List elements = treeSelection.toList();
        IWorkingSet result = null;
        for (Object element : elements) {
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return null;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() != 2) {
                return null;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return null;
            }
            if (result == null) {
                result = (IWorkingSet)candidate;
                continue;
            }
            if (result == candidate) continue;
            return null;
        }
        return result;
    }

    public void run(IStructuredSelection selection) {
        IWorkingSet ws = this.getWorkingSet(selection);
        if (ws == null) {
            return;
        }
        ArrayList elements = new ArrayList(Arrays.asList(ws.getElements()));
        List selectedElements = selection.toList();
        Iterator iter = selectedElements.iterator();
        while (iter.hasNext()) {
            elements.remove(iter.next());
        }
        ws.setElements(elements.toArray(new IAdaptable[elements.size()]));
    }
}

