/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.IInformationControlExtension4;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractReusableInformationControlCreator;
import org.eclipse.jdt.internal.ui.text.java.hover.BrowserInformationControl;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class JavadocHover
extends AbstractJavaEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_FLAGS = this.LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    int shellStyle = 20;
                    int style = 768;
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, shellStyle, style);
                    }
                    return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, 12, 0, JavadocHover.this.getTooltipAffordanceString());
                    }
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), JavadocHover.this.getTooltipAffordanceString());
                }

                public boolean canReuse(IInformationControl control) {
                    boolean canReuse = super.canReuse(control);
                    if (canReuse && control instanceof IInformationControlExtension4) {
                        ((IInformationControlExtension4)control).setStatusText(JavadocHover.this.getTooltipAffordanceString());
                    }
                    return canReuse;
                }
            };
        }
        return this.fHoverControlCreator;
    }

    protected String getHoverInfo(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText(curr));
                    hasContents = true;
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText((IJavaElement)member));
                try {
                    IPackageFragmentRoot root;
                    reader = JavadocContentAccess.getHTMLContentReader(member, true, true);
                    if (reader == null && member.isBinary() && (root = (IPackageFragmentRoot)member.getAncestor(3)) != null && root.getSourceAttachmentPath() == null && root.getAttachedJavadoc(null) == null) {
                        reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedInformation);
                    }
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, reader);
                }
                hasContents = true;
            } else if (curr.getElementType() == 14 || curr.getElementType() == 15) {
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText(curr));
                hasContents = true;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, JavadocHover.getStyleSheet());
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement member) {
        long flags = member.getElementType() == 14 ? this.LOCAL_VARIABLE_FLAGS : this.LABEL_FLAGS;
        String label = JavaElementLabels.getElementLabel(member, flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

