/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class ByteArray {
    private final byte[] value;

    public ByteArray(byte[] byArray) {
        this.value = byArray;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = this.value.length;
        for (int i = 0; i < n; i += 16) {
            int n2;
            printWriter.print(ByteArray.formatInt(i, 16, 8));
            printWriter.print("  ");
            int n3 = Math.min(16, n - i);
            String string = ByteArray.toHexString(this.value, i, n3, ' ');
            printWriter.print(string);
            for (n2 = 56 - (56 - string.length()); n2 < 56; ++n2) {
                printWriter.print(" ");
            }
            for (n2 = 0; n2 < n3; ++n2) {
                byte by = this.value[i + n2];
                if ((by & 0xFF) < 32 || (by & 0xFF) > 126) {
                    printWriter.print(".");
                    continue;
                }
                printWriter.print((char)((char)by & 0xFF));
            }
            printWriter.println();
        }
        return stringWriter.toString();
    }

    public static String toHexString(byte[] byArray, int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i + n] >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i + n] & 0xF, 16));
            if (i >= n2 - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String formatInt(int n, int n2, int n3) {
        String string = Integer.toString(n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3 - string.length(); ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

