/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CertificatePolicies
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.32");
    private final List policies;
    private final Map policyQualifierInfos;

    public CertificatePolicies(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue2 = dERReader.read();
        if (!dERValue2.isConstructed()) {
            throw new IOException("malformed CertificatePolicies");
        }
        LinkedList linkedList = new LinkedList();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < dERValue2.getLength(); i += dERValue.getEncodedLength()) {
            dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new IOException("malformed PolicyInformation");
            }
            DERValue dERValue3 = dERReader.read();
            if (dERValue3.getTag() != 6) {
                throw new IOException("malformed CertPolicyId");
            }
            OID oID = (OID)dERValue3.getValue();
            linkedList.add(oID);
            if (dERValue3.getEncodedLength() >= dERValue.getLength()) continue;
            DERValue dERValue4 = dERReader.read();
            LinkedList linkedList2 = new LinkedList();
            for (int j = 0; j < dERValue4.getLength(); j += dERValue3.getEncodedLength()) {
                dERValue3 = dERReader.read();
                linkedList2.add(new PolicyQualifierInfo(dERValue3.getEncoded()));
                dERReader.skip(dERValue3.getLength());
            }
            hashMap.put(oID, linkedList2);
        }
        this.policies = Collections.unmodifiableList(linkedList);
        this.policyQualifierInfos = Collections.unmodifiableMap(hashMap);
    }

    public CertificatePolicies(List list2, Map map) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof OID) continue;
            throw new IllegalArgumentException("policies must be OIDs");
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!(entry.getKey() instanceof OID) || !list2.contains(entry.getKey())) {
                throw new IllegalArgumentException("policyQualifierInfos keys must be OIDs");
            }
            if (!(entry.getValue() instanceof List)) {
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                if (iterator2.next() instanceof PolicyQualifierInfo) continue;
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
        }
        this.policies = Collections.unmodifiableList(new ArrayList(list2));
        this.policyQualifierInfos = Collections.unmodifiableMap(new HashMap(map));
    }

    public List getPolicies() {
        return this.policies;
    }

    public List getPolicyQualifierInfos(OID oID) {
        return (List)this.policyQualifierInfos.get(oID);
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList arrayList = new ArrayList(this.policies.size());
            Iterator iterator = this.policies.iterator();
            while (iterator.hasNext()) {
                OID oID = (OID)iterator.next();
                List list2 = this.getPolicyQualifierInfos(oID);
                ArrayList arrayList2 = new ArrayList(list2 == null ? 1 : 2);
                arrayList2.add(new DERValue(6, oID));
                if (list2 != null) {
                    ArrayList arrayList3 = new ArrayList(list2.size());
                    Iterator iterator2 = list2.iterator();
                    while (iterator.hasNext()) {
                        PolicyQualifierInfo policyQualifierInfo = (PolicyQualifierInfo)iterator2.next();
                        try {
                            arrayList3.add(DERReader.read(policyQualifierInfo.getEncoded()));
                        }
                        catch (IOException iOException) {}
                    }
                    arrayList2.add(new DERValue(48, arrayList3));
                }
                arrayList.add(new DERValue(48, arrayList2));
            }
            this.encoded = new DERValue(48, arrayList).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return CertificatePolicies.class$("gnu.java.security.x509.ext.CertificatePolicies").getName() + " [ policies=" + this.policies + " policyQualifierInfos=" + this.policyQualifierInfos + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

