/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class RenderContext
implements Cloneable {
    private AffineTransform xform;
    private Shape aoi;
    private RenderingHints hints;

    public RenderContext(AffineTransform affineTransform, Shape shape, RenderingHints renderingHints) {
        this.xform = affineTransform;
        this.aoi = shape;
        this.hints = renderingHints;
    }

    public RenderContext(AffineTransform affineTransform) {
        this(affineTransform, null, null);
    }

    public RenderContext(AffineTransform affineTransform, RenderingHints renderingHints) {
        this(affineTransform, null, renderingHints);
    }

    public RenderContext(AffineTransform affineTransform, Shape shape) {
        this(affineTransform, shape, null);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.hints = renderingHints;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.xform = affineTransform;
    }

    public void preConcatenateTransform(AffineTransform affineTransform) {
        this.preConcetenateTransform(affineTransform);
    }

    public void preConcetenateTransform(AffineTransform affineTransform) {
        this.xform.preConcatenate(affineTransform);
    }

    public void concatenateTransform(AffineTransform affineTransform) {
        this.concetenateTransform(affineTransform);
    }

    public void concetenateTransform(AffineTransform affineTransform) {
        this.xform.concatenate(affineTransform);
    }

    public AffineTransform getTransform() {
        return this.xform;
    }

    public void setAreaOfInterest(Shape shape) {
        this.aoi = shape;
    }

    public Shape getAreaOfInterest() {
        return this.aoi;
    }

    public Object clone() {
        try {
            RenderContext renderContext = (RenderContext)super.clone();
            if (this.xform != null) {
                renderContext.xform = (AffineTransform)this.xform.clone();
            }
            if (this.hints != null) {
                renderContext.hints = (RenderingHints)this.hints.clone();
            }
            return renderContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }
}

