/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import gnu.classpath.NotImplementedException;
import java.io.Serializable;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosKey
implements Serializable,
SecretKey,
Destroyable {
    private static final long serialVersionUID = -4625402278148246993L;
    private KerberosPrincipal principal;
    private int versionNum;
    private KeyImpl key;

    public KerberosKey(KerberosPrincipal kerberosPrincipal, byte[] byArray, int n, int n2) {
        this.principal = kerberosPrincipal;
        this.versionNum = n2;
        this.key = new KeyImpl(byArray, n);
    }

    public KerberosKey(KerberosPrincipal kerberosPrincipal, char[] cArray, String string) throws NotImplementedException {
        this.principal = kerberosPrincipal;
        this.versionNum = 0;
        this.key = new KeyImpl(cArray, string);
    }

    public final String getAlgorithm() {
        this.checkDestroyed();
        return this.key.algorithm;
    }

    public final String getFormat() {
        this.checkDestroyed();
        return "RAW";
    }

    public final KerberosPrincipal getPrincipal() {
        this.checkDestroyed();
        return this.principal;
    }

    public final int getKeyType() {
        this.checkDestroyed();
        return this.key.type;
    }

    public final int getVersionNumber() {
        this.checkDestroyed();
        return this.versionNum;
    }

    public final byte[] getEncoded() {
        this.checkDestroyed();
        return (byte[])this.key.key.clone();
    }

    public void destroy() throws DestroyFailedException {
        if (this.key == null) {
            throw new DestroyFailedException("already destroyed");
        }
        this.key = null;
    }

    public boolean isDestroyed() {
        return this.key == null;
    }

    private void checkDestroyed() {
        if (this.key == null) {
            throw new IllegalStateException("key is destroyed");
        }
    }

    public String toString() {
        return this.principal + ":" + this.versionNum;
    }
}

