/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.catalog.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeCatalogXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, ArchetypeCatalog archetypeCatalog) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeCatalog.getModelEncoding(), null);
        this.writeArchetypeCatalog(archetypeCatalog, "archetype-catalog", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeArchetype(Archetype archetype, String tagName, XmlSerializer serializer) throws IOException {
        if (archetype != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetype.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(archetype.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (archetype.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(archetype.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (archetype.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(archetype.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (archetype.getRepository() != null) {
                serializer.startTag(this.NAMESPACE, "repository").text(archetype.getRepository()).endTag(this.NAMESPACE, "repository");
            }
            if (archetype.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(archetype.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (archetype.getGoals() != null && archetype.getGoals().size() > 0) {
                serializer.startTag(this.NAMESPACE, "goals");
                iter = archetype.getGoals().iterator();
                while (iter.hasNext()) {
                    String goal = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "goal").text(goal).endTag(this.NAMESPACE, "goal");
                }
                serializer.endTag(this.NAMESPACE, "goals");
            }
            if (archetype.getProperties() != null && archetype.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = archetype.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)archetype.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeArchetypeCatalog(ArchetypeCatalog archetypeCatalog, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeCatalog != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeCatalog.getArchetypes() != null && archetypeCatalog.getArchetypes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "archetypes");
                Iterator iter = archetypeCatalog.getArchetypes().iterator();
                while (iter.hasNext()) {
                    Archetype o = (Archetype)iter.next();
                    this.writeArchetype(o, "archetype", serializer);
                }
                serializer.endTag(this.NAMESPACE, "archetypes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

