/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.TestNG;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.SuiteGenerator;
import org.testng.xml.XmlSuite;

class SearchingForTestsTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)("#" + SearchingForTestsTask.class.getName()));
    private final Map<PsiClass, Collection<PsiMethod>> myClasses;
    private Socket mySocket;
    private final TestData myData;
    private final Project myProject;
    private final ServerSocket myServerSocket;
    private final boolean myIs15;
    private final TestNGConfiguration myConfig;
    private final File myTempFile;

    public SearchingForTestsTask(ServerSocket serverSocket, boolean is15, TestNGConfiguration config, File tempFile) {
        super(config.getProject(), "Searching For Tests ...", true);
        this.myData = config.getPersistantData();
        this.myProject = config.getProject();
        this.myServerSocket = serverSocket;
        this.myIs15 = is15;
        this.myConfig = config;
        this.myTempFile = tempFile;
        this.myClasses = new HashMap<PsiClass, Collection<PsiMethod>>();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/SearchingForTestsTask.run must not be null");
        }
        try {
            this.mySocket = this.myServerSocket.accept();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        try {
            this.fillTestObjects();
        }
        catch (CantRunException e) {
            this.logCantRunException(e);
        }
    }

    public void onSuccess() {
        this.writeTempFile();
        this.connect();
    }

    public void onCancel() {
        this.connect();
    }

    public DumbModeAction getDumbModeAction() {
        return DumbModeAction.WAIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(this.mySocket.getOutputStream());
            os.writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                this.myServerSocket.close();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    private void writeTempFile() {
        if (this.myClasses.size() > 0) {
            this.composeTestSuiteFromClasses();
        } else if (TestType.SUITE.getType().equals(this.myData.TEST_OBJECT)) {
            try {
                this.composeTestSuiteFromXml();
            }
            catch (CantRunException e) {
                this.logCantRunException(e);
            }
        }
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])"end".getBytes(), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void logCantRunException(CantRunException e) {
        try {
            String message = "CantRunException" + e.getMessage();
            FileUtil.writeToFile((File)this.myTempFile, (byte[])message.getBytes());
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    private void composeTestSuiteFromClasses() {
        String groupName;
        HashMap map = new HashMap();
        for (final Map.Entry<PsiClass, Collection<PsiMethod>> entry : this.myClasses.entrySet()) {
            HashSet<String> methods = new HashSet<String>(entry.getValue().size());
            for (PsiMethod method : entry.getValue()) {
                methods.add(method.getName());
            }
            map.put(ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return ((PsiClass)entry.getKey()).getQualifiedName();
                }
            }), methods);
        }
        HashSet<String> groupNames = null;
        if (TestType.GROUP.getType().equals(this.myData.TEST_OBJECT) && (groupName = this.myData.getGroupName()) != null && groupName.length() > 0) {
            groupNames = new HashSet<String>(1);
            groupNames.add(groupName);
        }
        Map<String, String> testParams = this.buildTestParameters();
        String annotationType = this.myData.ANNOTATION_TYPE;
        if (annotationType == null || "".equals(annotationType)) {
            annotationType = this.myIs15 ? TestNG.JDK_ANNOTATION_TYPE : TestNG.JAVADOC_ANNOTATION_TYPE;
        }
        LOG.info("Using annotationType of " + annotationType);
        int logLevel = 1;
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(this.myConfig.getPersistantData().VM_PARAMETERS.getBytes()));
            String verbose = properties.getProperty("-Dtestng.verbose");
            if (verbose != null) {
                logLevel = Integer.parseInt(verbose);
            }
        }
        catch (Exception e) {
            logLevel = 1;
        }
        LaunchSuite suite = SuiteGenerator.createSuite((String)this.myProject.getName(), null, map, groupNames, testParams, (String)annotationType, (int)logLevel);
        File xmlFile = suite.save(new File(PathManager.getSystemPath()));
        String path = xmlFile.getAbsolutePath() + "\n";
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void composeTestSuiteFromXml() throws CantRunException {
        try {
            Collection suites;
            FileInputStream in = new FileInputStream(this.myData.getSuiteName());
            try {
                suites = new Parser((InputStream)in).parse();
            }
            finally {
                in.close();
            }
            for (XmlSuite suite : suites) {
                Map params = suite.getParameters();
                params.putAll(this.buildTestParameters());
                String annotationType = this.myData.ANNOTATION_TYPE;
                if (annotationType != null && !"".equals(annotationType)) {
                    suite.setAnnotations(annotationType);
                }
                LOG.info("Using annotationType of " + annotationType);
                String fileId = (this.myProject.getName() + '_' + suite.getName() + '_' + Integer.toHexString(suite.getName().hashCode()) + ".xml").replace(' ', '_');
                File suiteFile = new File(PathManager.getSystemPath(), fileId);
                FileWriter fileWriter = new FileWriter(suiteFile);
                try {
                    fileWriter.write(suite.toXml());
                }
                finally {
                    fileWriter.close();
                }
                String path = suiteFile.getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(), (boolean)true);
            }
        }
        catch (Exception e) {
            throw new CantRunException("Unable to parse suite: " + e.getMessage());
        }
    }

    protected void fillTestObjects() throws CantRunException {
        final TestData data = this.myConfig.getPersistantData();
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            final String packageName = data.getPackageName();
            PsiPackage psiPackage = (PsiPackage)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiPackage>(){

                @Nullable
                public PsiPackage compute() {
                    return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
                }
            });
            if (psiPackage == null) {
                throw CantRunException.packageNotFound((String)packageName);
            }
            TestSearchScope scope = this.myConfig.getPersistantData().getScope();
            TestClassFilter projectFilter = new TestClassFilter(scope.getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope(), this.myProject, true);
            TestClassFilter filter = projectFilter.intersectionWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            this.myClasses.putAll(this.calculateDependencies(null, TestNGUtil.getAllTestClasses(filter, false)));
            if (this.myClasses.size() == 0) {
                throw new CantRunException("No tests found in the package \"" + packageName + '\"');
            }
        } else if (data.TEST_OBJECT.equals(TestType.CLASS.getType())) {
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                @Nullable
                public PsiClass compute() {
                    return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(data.getMainClassName(), SearchingForTestsTask.this.getSearchScope());
                }
            });
            if (psiClass == null) {
                throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
            }
            if (null == ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return psiClass.getQualifiedName();
                }
            })) {
                throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
            }
            this.myClasses.putAll(this.calculateDependencies(null, psiClass));
        } else if (data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                @Nullable
                public PsiClass compute() {
                    return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(data.getMainClassName(), SearchingForTestsTask.this.getSearchScope());
                }
            });
            if (psiClass == null) {
                throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
            }
            if (null == ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return psiClass.getQualifiedName();
                }
            })) {
                throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
            }
            PsiMethod[] methods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

                public PsiMethod[] compute() {
                    return psiClass.findMethodsByName(data.getMethodName(), true);
                }
            });
            this.myClasses.putAll(this.calculateDependencies(methods, psiClass));
            Collection<PsiMethod> psiMethods = this.myClasses.get(psiClass);
            if (psiMethods == null) {
                psiMethods = new LinkedHashSet<PsiMethod>();
                this.myClasses.put(psiClass, psiMethods);
            }
            psiMethods.addAll(Arrays.asList(methods));
        } else if (data.TEST_OBJECT.equals(TestType.GROUP.getType())) {
            PsiClass[] testClasses;
            for (PsiClass c : testClasses = TestNGUtil.getAllTestClasses(new TestClassFilter(data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope(), this.myProject, true), false)) {
                this.myClasses.put(c, new HashSet());
            }
        }
    }

    private Map<String, String> buildTestParameters() {
        HashMap<String, String> testParams = new HashMap<String, String>();
        testParams.putAll(SearchingForTestsTask.convertPropertiesFileToMap(this.myData.PROPERTIES_FILE));
        testParams.putAll(this.myData.TEST_PROPERTIES);
        return testParams;
    }

    private static Map<String, String> convertPropertiesFileToMap(String properties_file) {
        File propertiesFile;
        HashMap<String, String> params = new HashMap<String, String>();
        if (properties_file != null && (propertiesFile = new File(properties_file)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    params.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return params;
    }

    private Map<PsiClass, Collection<PsiMethod>> calculateDependencies(PsiMethod[] methods, final PsiClass ... classes) {
        final HashMap<PsiClass, Collection<PsiMethod>> results = new HashMap<PsiClass, Collection<PsiMethod>>();
        if (classes != null && classes.length > 0) {
            final HashSet<String> dependencies = new HashSet<String>();
            TestNGUtil.collectAnnotationValues(dependencies, "dependsOnGroups", methods, classes);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (!dependencies.isEmpty()) {
                        Project project = classes[0].getProject();
                        if (!SearchingForTestsTask.this.myIs15) {
                            Collection allClasses = AllClassesSearch.search((SearchScope)SearchingForTestsTask.this.getSearchScope(), (Project)project).findAll();
                            Map<PsiClass, Collection<PsiMethod>> filteredClasses = TestNGUtil.filterAnnotations("groups", dependencies, allClasses);
                            results.putAll(filteredClasses);
                        } else {
                            PsiClass testAnnotation = JavaPsiFacade.getInstance((Project)project).findClass(TestNGUtil.TEST_ANNOTATION_FQN, GlobalSearchScope.allScope((Project)project));
                            LOG.assertTrue(testAnnotation != null);
                            for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)SearchingForTestsTask.this.getSearchScope())) {
                                if (!TestNGUtil.isAnnotatedWithParameter(AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{TestNGUtil.TEST_ANNOTATION_FQN}), "groups", dependencies)) continue;
                                PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
                                LinkedHashSet<PsiMethod> psiMethods = (LinkedHashSet<PsiMethod>)results.get(psiClass);
                                if (psiMethods == null) {
                                    psiMethods = new LinkedHashSet<PsiMethod>();
                                    results.put(psiClass, psiMethods);
                                }
                                if (!(psiMember instanceof PsiMethod)) continue;
                                psiMethods.add((PsiMethod)psiMember);
                            }
                        }
                    }
                }
            });
            if (methods == null) {
                for (PsiClass c : classes) {
                    results.put(c, new LinkedHashSet());
                }
            }
        }
        return results;
    }

    private GlobalSearchScope getSearchScope() {
        TestData data = this.myConfig.getPersistantData();
        Module module = ((JavaRunConfigurationModule)this.myConfig.getConfigurationModule()).getModule();
        return data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? this.myConfig.getPersistantData().getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope() : (module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)this.myConfig.getProject()));
    }
}

