/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DataInputOutputUtil {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    public static void skipUTF(DataInput record) throws IOException {
        record.skipBytes(record.readUnsignedShort());
    }

    public static StringRef readNAME(DataInput record, PersistentStringEnumerator nameStore) throws IOException {
        return StringRef.fromStream(record, nameStore);
    }

    public static void writeNAME(DataOutput record, String name, PersistentStringEnumerator nameStore) throws IOException {
        int nameId = name != null ? nameStore.enumerate(name) : 0;
        record.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(record, nameId >> 8);
    }

    public static void skipNAME(DataInput record) throws IOException {
        record.readUnsignedByte();
        DataInputOutputUtil.readINT(record);
    }

    public static void skipINT(DataInput record) throws IOException {
        DataInputOutputUtil.readINT(record);
    }

    public static int readINT(DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(DataOutput record, int val) throws IOException {
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    public static void skipSINT(DataInput record) throws IOException {
        DataInputOutputUtil.readSINT(record);
    }

    public static int readSINT(DataInput record) throws IOException {
        return DataInputOutputUtil.readINT(record) - 64;
    }

    public static void writeSINT(DataOutput record, int val) throws IOException {
        DataInputOutputUtil.writeINT(record, val + 64);
    }

    public static void writeTIME(DataOutput record, long timestamp) throws IOException {
        long relStamp = timestamp - 1040688000000L;
        if (relStamp < 0L || relStamp >= 0xFF00000000L) {
            record.writeByte(255);
            record.writeLong(timestamp);
        } else {
            record.writeByte((int)(relStamp >> 32));
            record.writeByte((int)(relStamp >> 24));
            record.writeByte((int)(relStamp >> 16));
            record.writeByte((int)(relStamp >> 8));
            record.writeByte((int)(relStamp >> 0));
        }
    }

    public static long readTIME(DataInput record) throws IOException {
        int first = record.readUnsignedByte();
        if (first == 255) {
            return record.readLong();
        }
        int second = record.readUnsignedByte();
        int third = record.readUnsignedByte() << 16;
        int fourth = record.readUnsignedByte() << 8;
        int fifth = record.readUnsignedByte();
        return ((long)(first << 8 | second) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }
}

