/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.util.Map;
import org.testng.TestNG;
import org.testng.collections.Maps;
import org.testng.internal.AnnotationDirectoryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConverter {
    private static final String SRC_DIR_OPT = "-srcdir";
    private static final String OUT_DIR_OPT = "-d";
    private static final String OVERWRITE_OPT = "-overwrite";
    private static final String QUIET = "-quiet";
    private static int m_logLevel = 1;

    public static void main(String[] args) {
        boolean overwrite;
        String srcPath;
        File src;
        if (args.length == 0) {
            AnnotationConverter.usage();
            return;
        }
        Map<String, Object> params = AnnotationConverter.extractOptions(args);
        if (null != params.get(QUIET)) {
            m_logLevel = 0;
        }
        if (null == params.get(SRC_DIR_OPT)) {
            TestNG.exitWithError("The source directory cannot be null");
        }
        if (!(src = new File(srcPath = (String)params.get(SRC_DIR_OPT))).exists() || !src.isDirectory()) {
            TestNG.exitWithError("Invalid source directory: " + src.getAbsolutePath());
        }
        boolean bl = overwrite = null != params.get(OVERWRITE_OPT);
        if (null != params.get(OUT_DIR_OPT) && overwrite) {
            TestNG.exitWithError("Cannot use both -d and --overwrite options");
        }
        if (null == params.get(OUT_DIR_OPT) && !overwrite) {
            TestNG.exitWithError("One of -d and --overwrite options is required");
        }
        File outFile = overwrite ? null : new File((String)params.get(OUT_DIR_OPT));
        AnnotationDirectoryConverter convertor = new AnnotationDirectoryConverter(new File(srcPath), outFile);
        int result = convertor.convert();
        switch (result) {
            case -1: {
                AnnotationConverter.log("Generation failed. Consult messages.");
                break;
            }
            case 0: {
                AnnotationConverter.log("No tests were generated");
            }
            default: {
                AnnotationConverter.log(result + " tests were generated");
            }
        }
    }

    private static void usage() {
        System.out.println("Converts Javadoc annotated test cases to Java 5 annotated cases");
        System.out.println("Usage: java -cp <> org.testng.AnnotationConverter -srcdir <source_dir> (-d <output_dir> | -overwrite) [-quiet]");
        System.out.println("");
        System.out.println("-srcdir\t Source directory containing original tests");
        System.out.println("-d\t\t Output directory for resulting TestNG tests");
        System.out.println("-overwrite\t Overwrite the original files with the new ones\n\t\t The flag cannot be used when -d is used.");
        System.out.println("-quiet\t Don't display any output");
    }

    private static Map<String, Object> extractOptions(String[] args) {
        Map<String, Object> options = Maps.newHashMap();
        for (int i = 0; i < args.length; ++i) {
            if (SRC_DIR_OPT.equals(args[i])) {
                if (i + 1 >= args.length) continue;
                options.put(SRC_DIR_OPT, args[i + 1]);
                ++i;
                continue;
            }
            if (OUT_DIR_OPT.equals(args[i])) {
                if (i + 1 >= args.length) continue;
                options.put(OUT_DIR_OPT, args[i + 1]);
                ++i;
                continue;
            }
            if (OVERWRITE_OPT.equals(args[i])) {
                options.put(OVERWRITE_OPT, Boolean.TRUE);
                continue;
            }
            if (!QUIET.equals(args[i])) continue;
            options.put(QUIET, Boolean.TRUE);
        }
        return options;
    }

    public static void log(String s) {
        if (AnnotationConverter.getLogLevel() > 0) {
            System.out.println("[AnnotationConverter] " + s);
        }
    }

    public static int getLogLevel() {
        return m_logLevel;
    }

    public static void ppp(String s) {
        System.out.println("[AnnotationConverter] " + s);
    }
}

