/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolTip;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.IdeaSubversionConfigurationDirectory;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.config.ConfigureProxiesListener;

public class SvnConfigurable
implements Configurable {
    private final Project myProject;
    private JCheckBox myUseDefaultCheckBox;
    private TextFieldWithBrowseButton myConfigurationDirectoryText;
    private JButton myClearAuthButton;
    private JCheckBox myUseCommonProxy;
    private JButton myEditProxiesButton;
    private JPanel myComponent;
    private JLabel myConfigurationDirectoryLabel;
    private JLabel myClearCacheLabel;
    private JLabel myUseCommonProxyLabel;
    private JLabel myEditProxyLabel;
    private JCheckBox myLockOnDemand;
    private JCheckBox myCheckNestedInQuickMerge;
    private JCheckBox myDetectNestedWorkingCopiesCheckBox;
    private JCheckBox myIgnoreWhitespaceDifferenciesInCheckBox;
    private JCheckBox myShowMergeSourceInAnnotate;
    private JSpinner myNumRevsInAnnotations;
    private JCheckBox myMaximumNumberOfRevisionsCheckBox;
    @NonNls
    private static final String HELP_ID = "project.propSubversion";

    public SvnConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myUseDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = !SvnConfigurable.this.myUseDefaultCheckBox.isSelected();
                SvnConfigurable.this.myConfigurationDirectoryText.setEnabled(enabled);
                SvnConfigurable.this.myConfigurationDirectoryLabel.setEnabled(enabled);
                SvnConfiguration configuration = SvnConfiguration.getInstance(SvnConfigurable.this.myProject);
                String path = configuration.getConfigurationDirectory();
                if (!enabled || path == null) {
                    SvnConfigurable.this.myConfigurationDirectoryText.setText(IdeaSubversionConfigurationDirectory.getPath());
                } else {
                    SvnConfigurable.this.myConfigurationDirectoryText.setText(path);
                }
            }
        });
        this.myClearAuthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                String path = SvnConfigurable.this.myConfigurationDirectoryText.getText();
                if (path != null && (result = Messages.showYesNoDialog((Component)SvnConfigurable.this.myComponent, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon())) == 0) {
                    SvnConfiguration.RUNTIME_AUTH_CACHE.clear();
                    SvnConfiguration.getInstance(SvnConfigurable.this.myProject).clearAuthenticationDirectory();
                }
            }
        });
        final FileChooserDescriptor descriptor = this.createFileDescriptor();
        this.myConfigurationDirectoryText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = SvnConfigurable.this.myConfigurationDirectoryText.getText().trim();
                path = "file://" + path.replace(File.separatorChar, '/');
                VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(path);
                String oldValue = PropertiesComponent.getInstance().getValue("FileChooser.showHiddens");
                PropertiesComponent.getInstance().setValue("FileChooser.showHiddens", Boolean.TRUE.toString());
                VirtualFile[] files = FileChooser.chooseFiles((Component)SvnConfigurable.this.myComponent, (FileChooserDescriptor)descriptor, (VirtualFile)root);
                PropertiesComponent.getInstance().setValue("FileChooser.showHiddens", oldValue);
                if (files.length != 1 || files[0] == null) {
                    return;
                }
                SvnConfigurable.this.myConfigurationDirectoryText.setText(files[0].getPath().replace('/', File.separatorChar));
            }
        });
        this.myConfigurationDirectoryText.setEditable(false);
        this.myConfigurationDirectoryLabel.setLabelFor((Component)this.myConfigurationDirectoryText);
        this.myUseCommonProxy.setText(SvnBundle.message("use.idea.proxy.as.default", ApplicationNamesInfo.getInstance().getProductName()));
        this.myEditProxiesButton.addActionListener(new ConfigureProxiesListener(this.myProject));
        this.myMaximumNumberOfRevisionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnConfigurable.this.myNumRevsInAnnotations.setEnabled(SvnConfigurable.this.myMaximumNumberOfRevisionsCheckBox.isSelected());
            }
        });
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
    }

    private FileChooserDescriptor createFileDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setShowFileSystemRoots(true);
        descriptor.setTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0]));
        descriptor.setDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0]));
        descriptor.setHideIgnored(false);
        return descriptor;
    }

    public JComponent createComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return HELP_ID;
    }

    public boolean isModified() {
        boolean useMaxInAnnot;
        if (this.myComponent == null) {
            return false;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        if (configuration.isUseDefaultConfiguation() != this.myUseDefaultCheckBox.isSelected()) {
            return true;
        }
        if (configuration.isIsUseDefaultProxy() != this.myUseCommonProxy.isSelected()) {
            return true;
        }
        if (configuration.UPDATE_LOCK_ON_DEMAND != this.myLockOnDemand.isSelected()) {
            return true;
        }
        if (configuration.DETECT_NESTED_COPIES != this.myDetectNestedWorkingCopiesCheckBox.isSelected()) {
            return true;
        }
        if (configuration.CHECK_NESTED_FOR_QUICK_MERGE != this.myCheckNestedInQuickMerge.isSelected()) {
            return true;
        }
        if (configuration.IGNORE_SPACES_IN_ANNOTATE != this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected()) {
            return true;
        }
        if (configuration.SHOW_MERGE_SOURCES_IN_ANNOTATE != this.myShowMergeSourceInAnnotate.isSelected()) {
            return true;
        }
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        boolean bl = useMaxInAnnot = annotateRevisions != -1;
        if (useMaxInAnnot != this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            return true;
        }
        if (this.myMaximumNumberOfRevisionsCheckBox.isSelected() && annotateRevisions != ((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue()) {
            return true;
        }
        return !configuration.getConfigurationDirectory().equals(this.myConfigurationDirectoryText.getText().trim());
    }

    public void apply() throws ConfigurationException {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        configuration.setConfigurationDirectory(this.myConfigurationDirectoryText.getText());
        configuration.setUseDefaultConfiguation(this.myUseDefaultCheckBox.isSelected());
        configuration.setIsUseDefaultProxy(this.myUseCommonProxy.isSelected());
        if (!configuration.DETECT_NESTED_COPIES && configuration.DETECT_NESTED_COPIES != this.myDetectNestedWorkingCopiesCheckBox.isSelected()) {
            SvnVcs.getInstance(this.myProject).invokeRefreshSvnRoots(true);
        }
        configuration.DETECT_NESTED_COPIES = this.myDetectNestedWorkingCopiesCheckBox.isSelected();
        configuration.CHECK_NESTED_FOR_QUICK_MERGE = this.myCheckNestedInQuickMerge.isSelected();
        configuration.UPDATE_LOCK_ON_DEMAND = this.myLockOnDemand.isSelected();
        configuration.setIgnoreSpacesInAnnotate(this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected());
        configuration.SHOW_MERGE_SOURCES_IN_ANNOTATE = this.myShowMergeSourceInAnnotate.isSelected();
        if (!this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            configuration.setMaxAnnotateRevisions(-1);
        } else {
            configuration.setMaxAnnotateRevisions(((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue());
        }
    }

    public void reset() {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        String path = configuration.getConfigurationDirectory();
        if (configuration.isUseDefaultConfiguation() || path == null) {
            path = IdeaSubversionConfigurationDirectory.getPath();
        }
        this.myConfigurationDirectoryText.setText(path);
        this.myUseDefaultCheckBox.setSelected(configuration.isUseDefaultConfiguation());
        this.myUseCommonProxy.setSelected(configuration.isIsUseDefaultProxy());
        this.myDetectNestedWorkingCopiesCheckBox.setSelected(configuration.DETECT_NESTED_COPIES);
        this.myCheckNestedInQuickMerge.setSelected(configuration.CHECK_NESTED_FOR_QUICK_MERGE);
        boolean enabled = !this.myUseDefaultCheckBox.isSelected();
        this.myConfigurationDirectoryText.setEnabled(enabled);
        this.myConfigurationDirectoryLabel.setEnabled(enabled);
        this.myLockOnDemand.setSelected(configuration.UPDATE_LOCK_ON_DEMAND);
        this.myIgnoreWhitespaceDifferenciesInCheckBox.setSelected(configuration.IGNORE_SPACES_IN_ANNOTATE);
        this.myShowMergeSourceInAnnotate.setSelected(configuration.SHOW_MERGE_SOURCES_IN_ANNOTATE);
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        if (annotateRevisions == -1) {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(false);
            this.myNumRevsInAnnotations.setValue(500);
        } else {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(true);
            this.myNumRevsInAnnotations.setValue(annotateRevisions);
        }
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myLockOnDemand = new JCheckBox(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        int value = configuration.getMaxAnnotateRevisions();
        value = value == -1 ? 500 : value;
        this.myNumRevsInAnnotations = new JSpinner(new SpinnerNumberModel(value, 10, 100000, 100));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel4;
        JPanel jPanel;
        this.createUIComponents();
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(19, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(18, 0, 1, 1, 0, 2, 5, 6, null, null, null));
        this.myConfigurationDirectoryLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.configuration.configuration.directory"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(319, 16), null));
        this.myConfigurationDirectoryText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 8, 0, 6, 0, null, new Dimension(319, 28), null));
        this.myUseDefaultCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.configure.use.system.default.configuration.directory"));
        jPanel.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(319, 23), null));
        this.myUseCommonProxy = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Use IDEA general proxy settings as default for Subversion");
        jPanel.add((Component)jCheckBox6, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(319, 23), null));
        this.myEditProxiesButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.edit.proxies"));
        jPanel.add((Component)jButton2, new GridConstraints(11, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myClearAuthButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.clear.authentication.cache"));
        jPanel.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myClearCacheLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.text.delete.stored.credentials"));
        Font font = jLabel3.getFont();
        jLabel3.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        ((Component)jLabel3).setEnabled(true);
        ((Component)jLabel3).setForeground(new Color(-10066330));
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myUseCommonProxyLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("use.idea.proxy.as.default.label.text"));
        ((Component)jLabel2).setEnabled(true);
        ((Component)jLabel2).setForeground(new Color(-10066330));
        jPanel.add((Component)jLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myEditProxyLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.text.edit.proxies"));
        ((Component)jLabel).setEnabled(true);
        ((Component)jLabel).setForeground(new Color(-10066330));
        jPanel.add((Component)jLabel, new GridConstraints(12, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        jPanel.add((Component)titledSeparator2, new GridConstraints(7, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        jPanel.add((Component)titledSeparator3, new GridConstraints(10, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        JCheckBox jCheckBox8 = this.myLockOnDemand;
        jCheckBox8.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.description"));
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.text.configurable"));
        jPanel.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDetectNestedWorkingCopiesCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("detect.nested.working.copies"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreWhitespaceDifferenciesInCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("svn.option.ignore.whitespace.in.annotate"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(17, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowMergeSourceInAnnotate = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("annotation.show.merge.sources.default.text"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(16, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(15, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JSpinner jSpinner = this.myNumRevsInAnnotations;
        jPanel2.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaximumNumberOfRevisionsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Maximum number of revisions to look back in annotations");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCheckNestedInQuickMerge = jCheckBox = new JCheckBox();
        jCheckBox.setText("Check svn:mergeinfo in target subtree when preparing for merge");
        jPanel.add((Component)jCheckBox, new GridConstraints(14, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

