/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.WCPaths;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;

public class WCInfo
implements WCPaths {
    private final String myPath;
    private final SVNURL myUrl;
    private final WorkingCopyFormat myFormat;
    private final String myRepositoryRoot;
    private final boolean myIsWcRoot;
    private final NestedCopyType myType;
    private final SVNDepth myStickyDepth;
    private final boolean myRepoSupportsMergeInfo;

    public WCInfo(String path, SVNURL url, WorkingCopyFormat format, String repositoryRoot, boolean isWcRoot, NestedCopyType type, SVNDepth stickyDepth, boolean repoSupportsMergeInfo) {
        this.myPath = path;
        this.myUrl = url;
        this.myFormat = format;
        this.myRepositoryRoot = repositoryRoot;
        this.myIsWcRoot = isWcRoot;
        this.myType = type;
        this.myStickyDepth = stickyDepth;
        this.myRepoSupportsMergeInfo = repoSupportsMergeInfo;
    }

    public SVNDepth getStickyDepth() {
        return this.myStickyDepth;
    }

    @Override
    public String getPath() {
        return this.myPath;
    }

    @Override
    public VirtualFile getVcsRoot() {
        return null;
    }

    public SVNURL getUrl() {
        return this.myUrl;
    }

    @Override
    public String getRootUrl() {
        return this.myUrl.toString();
    }

    @Override
    public String getRepoUrl() {
        return this.myRepositoryRoot;
    }

    public WorkingCopyFormat getFormat() {
        return this.myFormat;
    }

    public String getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return !(this.myPath != null ? !this.myPath.equals(wcInfo.myPath) : wcInfo.myPath != null);
    }

    public int hashCode() {
        return this.myPath != null ? this.myPath.hashCode() : 0;
    }

    public NestedCopyType getType() {
        return this.myType;
    }

    public boolean isRepoSupportsMergeInfo() {
        return this.myRepoSupportsMergeInfo;
    }
}

