/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.external.ui;

import java.io.File;
import java.lang.reflect.Constructor;
import org.gradle.openapi.external.ExternalUtility;
import org.gradle.openapi.external.ui.AlternateUIInteractionVersion1;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;
import org.gradle.openapi.external.ui.SinglePaneUIInteractionVersion1;
import org.gradle.openapi.external.ui.SinglePaneUIVersion1;

public class UIFactory {
    public static SinglePaneUIVersion1 createUI(ClassLoader parentClassLoader, File gradleHomeDirectory, SinglePaneUIInteractionVersion1 singlePaneUIArguments, boolean showDebugInfo) throws Exception {
        ClassLoader bootStrapClassLoader = ExternalUtility.getGradleClassloader(parentClassLoader, gradleHomeDirectory, showDebugInfo);
        Thread.currentThread().setContextClassLoader(bootStrapClassLoader);
        Class<?> soughtClass = null;
        try {
            soughtClass = bootStrapClassLoader.loadClass("org.gradle.openapi.wrappers.ui.OpenAPIUIWrapper");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (soughtClass == null) {
            return null;
        }
        Constructor<?> constructor = null;
        try {
            constructor = soughtClass.getDeclaredConstructor(SettingsNodeVersion1.class, AlternateUIInteractionVersion1.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.out.println("Dumping available constructors on " + soughtClass.getName() + "\n" + ExternalUtility.dumpConstructors(soughtClass));
            throw e;
        }
        Object singlePaneUI = constructor.newInstance(singlePaneUIArguments.instantiateSettings(), singlePaneUIArguments.instantiateAlternateUIInteraction());
        return (SinglePaneUIVersion1)singlePaneUI;
    }
}

