/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertTrueOrFalsePredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import com.siyeh.ipp.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class FlipAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
        return IntentionPowerPackBundle.message("flip.assert.literal.intention.name", fromMethodName, toMethodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertTrueOrFalsePredicate assertTrueOrFalsePredicate = new AssertTrueOrFalsePredicate();
        if (assertTrueOrFalsePredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/junit/FlipAssertLiteralIntention.getElementPredicate must not return null");
        }
        return assertTrueOrFalsePredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
        StringBuilder newCall = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            if (containingMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)containingMethod, (String)"org.junit.Test", (boolean)true)) {
                if (ImportUtils.nameCanBeStaticallyImported("org.junit.Assert", toMethodName, element)) {
                    ImportUtils.addStaticImport("org.junit.Assert", toMethodName, element);
                } else {
                    newCall.append("org.junit.Assert.");
                }
            }
        } else {
            newCall.append(qualifier.getText());
            newCall.append('.');
        }
        newCall.append(toMethodName);
        newCall.append('(');
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length == 1) {
            newCall.append(BoolUtils.getNegatedExpressionText(args[0]));
        } else {
            newCall.append(BoolUtils.getNegatedExpressionText(args[1]));
        }
        newCall.append(')');
        FlipAssertLiteralIntention.replaceExpression(newCall.toString(), (PsiExpression)call);
    }
}

