/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.impl.AntElementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntOuterProjectElement
extends AntElementImpl {
    private final int myStartOffset;
    private final String myText;

    public AntOuterProjectElement(AntFile parent, int startOffset, String text) {
        super(parent, null);
        this.myStartOffset = startOffset;
        this.myText = text;
    }

    @Override
    @NonNls
    public String toString() {
        return "XmlText: " + this.myText;
    }

    @Override
    public boolean isPhysical() {
        return this.getParent().isPhysical();
    }

    @Override
    public boolean isValid() {
        return this.getParent().isValid();
    }

    @Override
    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    public TextRange getTextRange() {
        return new TextRange(this.myStartOffset, this.myStartOffset + this.myText.length());
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getTextOffset() {
        return this.myStartOffset;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myText.toCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntOuterProjectElement.textToCharArray must not return null");
        }
        return cArray;
    }

    public boolean textContains(char c) {
        return this.myText.indexOf(c, 0) >= 0;
    }
}

