/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.Consumer;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.i18n.GitBundle;
import git4idea.rollback.GitRollbackEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRevert
extends BasicAction {
    @Override
    public boolean perform(final @NotNull Project project, GitVcs vcs, final @NotNull List<VcsException> exceptions, @NotNull VirtualFile[] affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitRevert.perform must not be null");
        }
        if (exceptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitRevert.perform must not be null");
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/actions/GitRevert.perform must not be null");
        }
        GitRevert.saveAll();
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        final ArrayList<Change> changes = new ArrayList<Change>();
        final HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        try {
            for (VirtualFile f : affectedFiles) {
                Change ch = changeManager.getChange(f);
                if (ch == null) continue;
                files.add(GitUtil.getGitRoot(f));
                changes.add(ch);
            }
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return true;
        }
        return this.toBackground(project, vcs, affectedFiles, exceptions, new Consumer<ProgressIndicator>(){

            public void consume(ProgressIndicator pi) {
                pi.setIndeterminate(true);
                GitRollbackEnvironment re = GitRollbackEnvironment.getInstance(project);
                re.rollbackChanges(changes, exceptions, RollbackProgressListener.EMPTY);
                if (changes.size() == 1) {
                    Change c = (Change)changes.get(0);
                    ContentRevision r = c.getAfterRevision();
                    if (r == null) {
                        r = c.getBeforeRevision();
                        assert (r != null);
                    }
                    pi.setText2(r.getFile().getPath());
                } else {
                    pi.setText2(GitBundle.message("revert.reverting.mulitple", changes.size()));
                }
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                for (Change c : changes) {
                    VirtualFile f;
                    ContentRevision after;
                    VirtualFile f2;
                    ContentRevision before = c.getBeforeRevision();
                    if (before != null && (f2 = lfs.refreshAndFindFileByPath(before.getFile().getPath())) != null) {
                        files.add(f2);
                    }
                    if ((after = c.getAfterRevision()) == null || (f = lfs.refreshAndFindFileByPath(after.getFile().getPath())) == null) continue;
                    files.add(f);
                }
                RefreshSession session = RefreshQueue.getInstance().createSession(true, true, new Runnable(){

                    @Override
                    public void run() {
                        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                        for (Change c : changes) {
                            ContentRevision after;
                            ContentRevision before = c.getBeforeRevision();
                            if (before != null) {
                                mgr.fileDirty(before.getFile());
                            }
                            if ((after = c.getAfterRevision()) == null) continue;
                            mgr.fileDirty(after.getFile());
                        }
                    }
                });
                session.addAllFiles((Collection)files);
                session.launch();
            }
        });
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("revert.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitRevert.getActionName must not return null");
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull Project project, @NotNull GitVcs vcs, VirtualFile ... vFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitRevert.isEnabled must not be null");
        }
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitRevert.isEnabled must not be null");
        }
        if (vFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitRevert.isEnabled must not be null");
        }
        for (VirtualFile file : vFiles) {
            FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED) continue;
            return false;
        }
        return true;
    }
}

