/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ListWithSelection;
import com.intellij.util.ui.ComboBoxTableCellEditor;
import com.intellij.util.ui.ComboBoxTableCellRenderer;
import git4idea.actions.GitShowAllSubmittedFilesAction;
import git4idea.commands.StringScanner;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntry;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;

public class GitRebaseEditor
extends DialogWrapper {
    private JTable myCommitsTable;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JButton myViewButton;
    private JPanel myPanel;
    private final MyTableModel myTableModel;
    private final String myFile;
    private final Project myProject;
    private final VirtualFile myGitRoot;
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    protected GitRebaseEditor(final Project project, final VirtualFile gitRoot, String file) throws IOException {
        super(project, true);
        this.myProject = project;
        this.myGitRoot = gitRoot;
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("rebase.editor.title"));
        this.setOKButtonText(GitBundle.getString("rebase.editor.button"));
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            file = file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
        }
        this.myFile = file;
        this.myTableModel = new MyTableModel();
        this.myTableModel.load(file);
        this.myCommitsTable.setModel(this.myTableModel);
        this.myCommitsTable.setSelectionMode(0);
        TableColumn actionColumn = this.myCommitsTable.getColumnModel().getColumn(0);
        actionColumn.setCellEditor((TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        actionColumn.setCellRenderer((TableCellRenderer)ComboBoxTableCellRenderer.INSTANCE);
        this.myCommitsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean selected = GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() != 0;
                GitRebaseEditor.this.myMoveUpButton.setEnabled(selected);
                if (selected) {
                    GitRebaseEditor.this.myViewButton.setEnabled(true);
                    int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
                    GitRebaseEditor.this.myMoveUpButton.setEnabled(row != 0);
                    GitRebaseEditor.this.myMoveDownButton.setEnabled(row != ((GitRebaseEditor)GitRebaseEditor.this).myTableModel.myEntries.size() - 1);
                } else {
                    GitRebaseEditor.this.myMoveUpButton.setEnabled(false);
                    GitRebaseEditor.this.myMoveDownButton.setEnabled(false);
                    GitRebaseEditor.this.myViewButton.setEnabled(false);
                }
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                GitRebaseEntry entry = ((GitRebaseEditor)GitRebaseEditor.this).myTableModel.myEntries.get(row);
                GitShowAllSubmittedFilesAction.showSubmittedFiles(project, entry.getCommit(), gitRoot);
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
                if (GitRebaseEditor.this.myTableModel.moveUp(row)) {
                    GitRebaseEditor.this.myCommitsTable.getSelectionModel().setSelectionInterval(row - 1, row - 1);
                }
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
                if (GitRebaseEditor.this.myTableModel.moveDown(row)) {
                    GitRebaseEditor.this.myCommitsTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                }
            }
        });
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GitRebaseEditor.this.validateFields();
            }
        });
        this.init();
    }

    private void validateFields() {
        int i;
        ArrayList<GitRebaseEntry> entries = this.myTableModel.myEntries;
        if (entries.size() == 0) {
            this.setErrorText(GitBundle.getString("rebase.editor.invalid.entryset"));
            this.setOKActionEnabled(false);
            return;
        }
        for (i = 0; i < entries.size() && entries.get(i).getAction() == GitRebaseEntry.Action.skip; ++i) {
        }
        if (i < entries.size() && entries.get(i).getAction() == GitRebaseEntry.Action.squash) {
            this.setErrorText(GitBundle.getString("rebase.editor.invalid.squash"));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public void save() throws IOException {
        this.myTableModel.save(this.myFile);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.RebaseCommits";
    }

    public void cancel() throws IOException {
        this.myTableModel.cancel(this.myFile);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTable jTable;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMoveUpButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.up"));
        ((Component)jButton3).setEnabled(false);
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.up.tooltip"));
        jPanel2.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMoveDownButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.down"));
        ((Component)jButton2).setEnabled(false);
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.down.tooltip"));
        jPanel2.add((Component)jButton2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myViewButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.view"));
        ((Component)jButton).setEnabled(false);
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.view.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myCommitsTable = jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.message"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final int ACTION = 0;
        private static final int COMMIT = 1;
        private static final int SUBJECT = 2;
        final ArrayList<GitRebaseEntry> myEntries = new ArrayList();

        private MyTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? ListWithSelection.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return GitBundle.getString("rebase.editor.action.column");
                }
                case 1: {
                    return GitBundle.getString("rebase.editor.commit.column");
                }
                case 2: {
                    return GitBundle.getString("rebase.editor.comment.column");
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + column);
        }

        @Override
        public int getRowCount() {
            return this.myEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new ListWithSelection(Arrays.asList(GitRebaseEntry.Action.values()), (Object)e.getAction());
                }
                case 1: {
                    return e.getCommit();
                }
                case 2: {
                    return e.getSubject();
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            e.setAction((GitRebaseEntry.Action)((Object)aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void load(String file) throws IOException {
            String encoding = GitConfigUtil.getLogEncoding(GitRebaseEditor.this.myProject, GitRebaseEditor.this.myGitRoot);
            StringScanner s = new StringScanner(new String(FileUtil.loadFileText((File)new File(file), (String)encoding)));
            while (s.hasMoreData()) {
                if (s.isEol() || s.startsWith('#') || s.startsWith("noop")) {
                    s.nextLine();
                    continue;
                }
                String action = s.spaceToken();
                assert ("pick".equals(action)) : "Initial action should be pick: " + action;
                String hash = s.spaceToken();
                String comment = s.line();
                this.myEntries.add(new GitRebaseEntry(hash, comment));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(String file) throws IOException {
            String encoding = GitConfigUtil.getLogEncoding(GitRebaseEditor.this.myProject, GitRebaseEditor.this.myGitRoot);
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            try {
                for (GitRebaseEntry e : this.myEntries) {
                    if (e.getAction() == GitRebaseEntry.Action.skip) continue;
                    out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
                }
            }
            finally {
                out.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(String file) throws IOException {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            try {
                out.println("# rebase is cancelled");
            }
            finally {
                out.close();
            }
        }

        public boolean moveUp(int row) {
            if (row < 1 || row >= this.myEntries.size()) {
                return false;
            }
            GitRebaseEditor.this.myCommitsTable.removeEditor();
            GitRebaseEntry e = this.myEntries.get(row);
            this.myEntries.set(row, this.myEntries.get(row - 1));
            this.myEntries.set(row - 1, e);
            this.fireTableRowsUpdated(row - 1, row);
            return true;
        }

        public boolean moveDown(int row) {
            if (row < 0 || row >= this.myEntries.size() - 1) {
                return false;
            }
            GitRebaseEditor.this.myCommitsTable.removeEditor();
            GitRebaseEntry e = this.myEntries.get(row);
            this.myEntries.set(row, this.myEntries.get(row + 1));
            this.myEntries.set(row + 1, e);
            this.fireTableRowsUpdated(row, row + 1);
            return true;
        }
    }
}

