/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssertWithSideEffectsInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/AssertWithSideEffectsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/AssertWithSideEffectsInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    private static boolean methodHasSideEffects(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        MethodSideEffectVisitor visitor = new MethodSideEffectVisitor();
        body.accept((PsiElementVisitor)visitor);
        return visitor.hasSideEffects();
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementVisitor {
        private boolean hasSideEffects = false;

        private MethodSideEffectVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            this.checkExpression(expression.getLExpression());
            super.visitAssignmentExpression(expression);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression.getOperand());
            }
            super.visitPrefixExpression(expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression.getOperand());
            }
            super.visitPostfixExpression(expression);
        }

        private void checkExpression(PsiExpression operand) {
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiField) {
                this.hasSideEffects = true;
            }
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }
    }

    private static class SideEffectVistor
    extends JavaRecursiveElementVisitor {
        private boolean hasSideEffects = false;

        private SideEffectVistor() {
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.hasSideEffects = true;
        }

        public void visitElement(PsiElement element) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (AssertWithSideEffectsInspection.methodHasSideEffects(method)) {
                this.hasSideEffects = true;
            } else {
                super.visitMethodCallExpression(expression);
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            }
        }
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression condition = statement.getAssertCondition();
            if (condition == null) {
                return;
            }
            SideEffectVistor visitor = new SideEffectVistor();
            condition.accept((PsiElementVisitor)visitor);
            if (!visitor.hasSideEffects()) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

