/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryReturnInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UnnecessaryReturnStatement" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryReturnInspection.getID must not return null");
        }
        return "UnnecessaryReturnStatement";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.return.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryReturnInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean isConstructor = (Boolean)infos[0];
        if (isConstructor) {
            string = InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryReturnInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor1", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryReturnInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("return");
    }

    private static class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryReturnVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            Boolean isConstructor;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/UnnecessaryReturnInspection$UnnecessaryReturnVisitor.visitReturnStatement must not be null");
            }
            super.visitReturnStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            if (method == null) {
                return;
            }
            if (method.isConstructor()) {
                isConstructor = Boolean.TRUE;
            } else {
                PsiType returnType = method.getReturnType();
                if (!PsiType.VOID.equals(returnType)) {
                    return;
                }
                isConstructor = Boolean.FALSE;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.blockCompletesWithStatement(body, (PsiStatement)statement)) {
                this.registerStatementError((PsiStatement)statement, isConstructor);
            }
        }
    }
}

