/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_boxingArgs = new HashMap<String, String>(9);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryBoxingInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryBoxingInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    static {
        s_boxingArgs.put("java.lang.Integer", "int");
        s_boxingArgs.put("java.lang.Short", "short");
        s_boxingArgs.put("java.lang.Boolean", "boolean");
        s_boxingArgs.put("java.lang.Long", "long");
        s_boxingArgs.put("java.lang.Byte", "byte");
        s_boxingArgs.put("java.lang.Float", "float");
        s_boxingArgs.put("java.lang.Double", "double");
        s_boxingArgs.put("java.lang.Long", "long");
        s_boxingArgs.put("java.lang.Character", "char");
    }

    private static class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor.visitNewExpression must not be null");
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return;
            }
            super.visitNewExpression(expression);
            PsiType constructorType = expression.getType();
            if (constructorType == null) {
                return;
            }
            String constructorTypeText = constructorType.getCanonicalText();
            if (!s_boxingArgs.containsKey(constructorTypeText)) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter arg = parameters[0];
            PsiType argumentType = arg.getType();
            String argumentTypeText = argumentType.getCanonicalText();
            String boxableConstructorType = s_boxingArgs.get(constructorTypeText);
            if (!boxableConstructorType.equals(argumentTypeText)) {
                return;
            }
            if (!UnnecessaryBoxingVisitor.canBeUnboxed((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return;
            }
            if (!(expressions[0].getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null || !referenceName.equals("valueOf")) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (s_boxingArgs.get(canonicalText) == null) {
                return;
            }
            if (!UnnecessaryBoxingVisitor.canBeUnboxed((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean canBeUnboxed(PsiExpression expression) {
            PsiMethodCallExpression containingMethodCallExpression;
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return false;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiClassType classType;
                PsiClass aClass;
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                PsiType castType = castExpression.getType();
                if (castType instanceof PsiClassType && (aClass = (classType = (PsiClassType)castType).resolve()) instanceof PsiTypeParameter) {
                    return false;
                }
            } else if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null || thenExpression == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false)) {
                    PsiType type = elseExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false)) {
                    PsiType type = thenExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                return true;
            }
            return (containingMethodCallExpression = UnnecessaryBoxingVisitor.getParentMethodCallExpression((PsiElement)expression)) == null || UnnecessaryBoxingVisitor.isSameMethodCalledWithoutBoxing(containingMethodCallExpression, expression);
        }

        @Nullable
        private static PsiMethodCallExpression getParentMethodCallExpression(@NotNull PsiElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor.getParentMethodCallExpression must not be null");
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiExpressionList) {
                return UnnecessaryBoxingVisitor.getParentMethodCallExpression(parent);
            }
            if (parent instanceof PsiMethodCallExpression) {
                return (PsiMethodCallExpression)parent;
            }
            return null;
        }

        private static boolean isSameMethodCalledWithoutBoxing(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull PsiExpression boxingExpression) {
            PsiMethod[] methods;
            if (methodCallExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor.isSameMethodCalledWithoutBoxing must not be null");
            }
            if (boxingExpression == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor.isSameMethodCalledWithoutBoxing must not be null");
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod originalMethod = (PsiMethod)element;
            String name = originalMethod.getName();
            PsiClass containingClass = originalMethod.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiType[] types = new PsiType[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                PsiType type = expression.getType();
                if (boxingExpression.equals(expression)) {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
                    if (unboxedType == null) {
                        return false;
                    }
                    types[i] = unboxedType;
                    continue;
                }
                types[i] = type;
            }
            for (PsiMethod method : methods = containingClass.findMethodsByName(name, true)) {
                if (originalMethod.equals(method) || !MethodCallUtils.isApplicable(method, PsiSubstitutor.EMPTY, types)) continue;
                return false;
            }
            return true;
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingFix.doFix must not be null");
            }
            PsiCallExpression expression = (PsiCallExpression)descriptor.getPsiElement();
            PsiType boxedType = expression.getType();
            if (boxedType == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiType argumentType = arguments[0].getType();
            if (argumentType == null) {
                return;
            }
            String cast = UnnecessaryBoxingFix.getCastString(argumentType, boxedType);
            String newExpression = arguments[0].getText();
            UnnecessaryBoxingFix.replaceExpression((PsiExpression)expression, cast + newExpression);
        }

        private static String getCastString(@NotNull PsiType fromType, @NotNull PsiType toType) {
            String unboxedType;
            if (fromType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingFix.getCastString must not be null");
            }
            if (toType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/jdk15/UnnecessaryBoxingInspection$UnnecessaryBoxingFix.getCastString must not be null");
            }
            String toTypeText = toType.getCanonicalText();
            String fromTypeText = fromType.getCanonicalText();
            if (fromTypeText.equals(unboxedType = s_boxingArgs.get(toTypeText))) {
                return "";
            }
            return '(' + unboxedType + ')';
        }
    }
}

