/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnpredictableBigDecimalConstructorCallInspection
extends BaseInspection {
    public boolean ignoreReferences = true;
    public boolean ignoreComplexLiterals = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.references.option", new Object[0]), "ignoreReferences");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.complex.literals.option", new Object[0]), "ignoreComplexLiterals");
        return optionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiNewExpression newExpression = (PsiNewExpression)infos[0];
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return null;
        }
        PsiExpression firstArgument = arguments[0];
        if (!(firstArgument instanceof PsiLiteralExpression)) {
            return null;
        }
        return new ReplaceDoubleArgumentWithStringFix(firstArgument.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnpredictableBigDecimalConstructorCallVisitor();
    }

    private class UnpredictableBigDecimalConstructorCallVisitor
    extends BaseInspectionVisitor {
        private UnpredictableBigDecimalConstructorCallVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            if (classReference == null) {
                return;
            }
            String name = classReference.getReferenceName();
            if (!"BigDecimal".equals(name)) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int length = parameterList.getParametersCount();
            if (length != 1 && length != 2) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter firstParameter = parameters[0];
            PsiType type = firstParameter.getType();
            if (type != PsiType.DOUBLE) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            if (!this.checkArguments(firstArgument)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private boolean checkArguments(@Nullable PsiExpression firstArgument) {
            if (firstArgument == null) {
                return false;
            }
            if (firstArgument instanceof PsiReferenceExpression) {
                if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreReferences) {
                    return false;
                }
            } else if (firstArgument instanceof PsiBinaryExpression) {
                if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreComplexLiterals) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)firstArgument;
                PsiExpression lhs = binaryExpression.getLOperand();
                if (!this.checkArguments(lhs)) {
                    return false;
                }
                PsiExpression rhs = binaryExpression.getROperand();
                if (!this.checkArguments(rhs)) {
                    return false;
                }
            }
            return true;
        }
    }

    private class ReplaceDoubleArgumentWithStringFix
    extends InspectionGadgetsFix {
        private final String argumentText;

        public ReplaceDoubleArgumentWithStringFix(String argumentText) {
            this.argumentText = argumentText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.quickfix", this.argumentText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection$ReplaceDoubleArgumentWithStringFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            ReplaceDoubleArgumentWithStringFix.replaceExpression(firstArgument, '\"' + firstArgument.getText() + '\"');
        }
    }
}

