/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MethodMayBeStaticInspection
extends BaseInspection {
    public boolean m_onlyPrivateOrFinal = false;
    public boolean m_ignoreEmptyMethods = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/MethodMayBeStaticInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/MethodMayBeStaticInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static");
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.only.option", new Object[0]), "m_onlyPrivateOrFinal");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.empty.option", new Object[0]), "m_ignoreEmptyMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeStaticVisitor();
    }

    private class MethodCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeStaticVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Condition[] addins;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/MethodMayBeStaticInspection$MethodCanBeStaticVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || method.hasModifierProperty("synchronized")) {
                return;
            }
            if (method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreEmptyMethods && MethodUtils.isEmpty(method)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)method);
            if (containingClass == null) {
                return;
            }
            ExtensionsArea rootArea = Extensions.getRootArea();
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.cantBeStatic");
            for (Condition addin : addins = (Condition[])extensionPoint.getExtensions()) {
                if (!addin.value((Object)method)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile) && !containingClass.hasModifierProperty("static")) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_onlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
                return;
            }
            Query superMethodQuery = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false);
            if (superMethodQuery.findFirst() != null) {
                return;
            }
            if (MethodUtils.isOverridden(method)) {
                return;
            }
            MethodReferenceVisitor visitor = new MethodReferenceVisitor((PsiMember)method);
            method.accept((PsiElementVisitor)visitor);
            if (!visitor.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

