/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class CodeStyleAbstractConfigurable
implements Configurable {
    private CodeStyleAbstractPanel myPanel;
    private final CodeStyleSettings mySettings;
    private final CodeStyleSettings myCloneSettings;
    private final String myDisplayName;
    private CodeStyleSchemesModel myModel;

    public CodeStyleAbstractConfigurable(CodeStyleSettings settings, CodeStyleSettings cloneSettings, String displayName) {
        this.mySettings = settings;
        this.myCloneSettings = cloneSettings;
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent createComponent() {
        this.myPanel = this.createPanel(this.myCloneSettings);
        this.myPanel.setModel(this.myModel);
        return this.myPanel.getPanel();
    }

    protected abstract CodeStyleAbstractPanel createPanel(CodeStyleSettings var1);

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply(this.mySettings);
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset(this.mySettings);
        }
    }

    public void resetFromClone() {
        if (this.myPanel != null) {
            this.myPanel.reset(this.myCloneSettings);
        }
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified(this.mySettings);
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    public CodeStyleAbstractPanel getPanel() {
        return this.myPanel;
    }

    public void setModel(CodeStyleSchemesModel model) {
        if (this.myPanel != null) {
            this.myPanel.setModel(model);
        }
        this.myModel = model;
    }

    public void onSomethingChanged() {
        this.myPanel.onSomethingChanged();
    }
}

